
<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
require_once '../assets/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener el ID del historial médico
$idHistorialMedico = $_GET["id"];


$sql = "SELECT hm.id_historial, hm.id_cliente, hm.id_medico, hm.fecha, hm.texto_historial, hm.indicaciones_medicas, hm.proxima_consulta, c.nombre AS nombre_paciente, c.apellido AS apellido_paciente, c.cedula AS cedula_paciente, c.fecha_nacimiento AS fecha_nacimiento, u.nombre AS nombre_medico, u.apellido AS apellido_medico
        FROM historial_medico hm
        JOIN clientes c ON hm.id_cliente = c.id_cliente
        JOIN usuarios u ON hm.id_medico = u.id_usuario
        WHERE hm.id_historial = '$idHistorialMedico'";

$historialMedico = array();
$result = ejecutarConsulta($sql);


while ($row = $result->fetch_assoc()) {
    $historialMedico[] = array(
        'id_historial_medico' => $row['id_historial'],
        'id_cliente' => $row['id_cliente'],
        'id_medico' => $row['id_medico'],
        'fecha' => $row['fecha'],
        'texto_historial' => $row['texto_historial'],
        'indicaciones_medicas' => $row['indicaciones_medicas'],
        'proxima_consulta' => $row['proxima_consulta'],
        'nombre_paciente' => $row['nombre_paciente'],
        'apellido_paciente' => $row['apellido_paciente'],
        'cedula' => $row['cedula_paciente'],
        'fecha_nacimiento' => $row['fecha_nacimiento'],
        'nombre_medico' => $row['nombre_medico'],
        'apellido_medico' => $row['apellido_medico']
    );

}

function calcularEdad($fechaNacimiento)
{
    $fechaActual = date("Y-m-d");
    $diferencia = strtotime($fechaActual) - strtotime($fechaNacimiento);
    $edad = floor($diferencia / (60 * 60 * 24 * 365));
    return $edad;
}


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Informe de consulta</title>
</head>
<style>
body {

    /* background-image: url("../assets/images/recetario.png");
    background-repeat: no-repeat; */
    font-family: sans-serif;
    font-size: 16px;
}

#cabecera {

    padding: 20px;
    
}

#cedula {
    margin-top: 18px;
    margin-left: 140px;    
}

#datos {
    
    margin-left: 280px;    
}

#diagnostico {
    margin-top: 20px;
    margin-left: 190px;
}
#proxconsulta {
    margin-top: 18px;
    margin-left: 340px;
}
#indicaciones {
    margin-top: 70px;
    margin-left: 100px;

    width: 500px;
    height: 600px;
    overflow: hidden;
    word-wrap: break-word;
    text-align: justify;


}

#firma {
    padding: 10px;
}

img {
    width: 100px;
}

h2 {
    font-size: 20px;
    font-weight: bold;
}

p {
    font-size: 16px;
}

.container {
    width: 21cm;
    min-height: 10cm;
}
</style>
<body style="background-image: url('../assets/images/recetario.png'); background-repeat: no-repeat;">
    
    <div class="container">
        <div id="cabecera">


        </div>
        <div id="datos">
            <br><br><br><br><br><br><br><br><br>
            <?php echo $historialMedico[0]['nombre_paciente'] . " " . $historialMedico[0]['apellido_paciente']; ?>
        </div>

        <div id="cedula">
            <?php
            echo $historialMedico[0]['cedula'];
            //agregar espacios
            echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;";

            // Verifica si la fecha de nacimiento no es null antes de calcular la edad
            if ($historialMedico[0]['fecha_nacimiento'] !== null) {
                echo calcularEdad($historialMedico[0]['fecha_nacimiento']) . " años";
            } else {
                echo "No disponible";
            }
            ?>
        </div>



        <div id="proxconsulta">
            <?php 
            // formatear fecha
            $fecha = $historialMedico[0]['proxima_consulta'];
            $fecha = date("d-m-Y", strtotime($fecha));
            echo $fecha;
            ?>
        </div>
        <div id="diagnostico">
            <?php echo $historialMedico[0]['texto_historial']; ?>
        </div>
        <div id="indicaciones">
            <?php echo $historialMedico[0]['indicaciones_medicas']; ?>
        </div>
        
    </div>
    <script>
        
        function descargarPDF() {
            // Contenido HTML que deseas convertir a PDF
            var html = document.documentElement.outerHTML;

            // Crea un objeto de la clase DOMPDF
            var dompdf = new Dompdf();

            // Establece las opciones (puedes ajustar según tus necesidades)
            var options = new Options();

            $options->set('isRemoteEnabled', true);
            $options->set('isPhpEnabled', true);
            $dompdf->setOptions($options);

            // Carga el HTML
            $dompdf->loadHtml($html);

            // Establece el tamaño de la página
            $dompdf->setPaper('A4', 'portrait', ['background' => 'url('../assets/images/recetario.png')']);
            // Genera el PDF
            $dompdf->render();

            // Descarga el PDF
            $dompdf->stream('informe.pdf');
        }
    </script>

    
</body>
</html>
