<?php

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();
// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener la lista de clientes
function obtenerClientes()
{
    $sql = "SELECT c.*, cat.nombre_categoria AS nombre_categoria
    FROM clientes c
    LEFT JOIN categoria_cliente cat ON c.id_categoria = cat.id_categoria";
    return ejecutarConsulta($sql);

}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Tus enlaces CSS existentes -->
    <title>Dentox - Pacientes</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Listado de Pacientes</h2>
                            <a href="agregar_clientes.php">
                            <button type="button" class="btn btn-primary" href="agregar_clientes.php"> 
                            Agregar Paciente
                            </button>
                            </a>
                        </div>
                        <div class="card-body table-responsive">
                            <?php
                            // Obtener la lista de clientes
                            $result = obtenerClientes();

                            // Verificar si hay resultados
                            if ($result->num_rows > 0) {
                                echo "<table id='tablaClientes' class='table'>
                                        <thead>
                                            <tr>
                                                <th hidden>ID</th>
                                                <th>Nombre</th>
                                                <th>Apellido</th>
                                                <th>Cédula</th>
                                                <th>Categoria</th>
                                                <th>Resumen Administrativo</th>
                                                <th>Teléfono de Contacto</th>
                                                <th>Email de Contacto</th>
                                                <th>Ficha</th>
                                                <th>Acciones</th>
                                            </tr>
                                        </thead>
                                        <tbody>";

                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>
                                            <td hidden>{$row['id_cliente']}</td>
                                            <td>{$row['nombre']}</td>
                                            <td>{$row['apellido']}</td>
                                            <td>{$row['cedula']}</td>
                                            <td>{$row['nombre_categoria']}</td>
                                            <td>{$row['resumen_administrativo']}</td>
                                            <td>{$row['contacto_telefono']}</td>
                                            <td>{$row['contacto_email']}</td>
                                            <td>
                                                <a href='#' class='btn-ficha' title='Ver Ficha'>
                                                    <i class='fa fa-file-medical'></i>
                                                </a>
                                            <td>
                                                <a href='#' class='btn-editar' title='Editar'>
                                                    <i class='fa fa-edit'></i>
                                                </a>
                                                <a href='#' class='btn-borrar' title='Borrar'>
                                                    <i class='fa fa-minus' style='color:red;'></i>
                                                </a>
                                            </td>
                                        </tr>";
                                }

                                echo "</tbody></table>";
                            } else {
                                echo "<p>No hay Pacientes registrados.</p>";
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Agrega el script de DataTables -->
    <script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.html5.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.dataTables.min.css">
    <script>
        $(document).ready(function () {
            // Inicializar el DataTable y personalizar la disposición de los elementos
            $('#tablaClientes').DataTable({
                dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                    "<'row'<'col-md-12'tr>>" +
                    "<'row'<'col-md-6'i><'col-md-6'p>>",
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
                },
                buttons: [
                    {
                        extend: 'excelHtml5',
                        text: 'Exportar a Excel',
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        text: 'Agregar Nuevo Paciente',
                        attr: {
                            id: 'btnAgregar',
                            class: 'btn btn-primary'
                        },
                        action: function () {
                            window.location.href = 'agregar_clientes.php'
                        }
                    }
                ],
                columnDefs: [
                    {
                        targets: -1,
                        width: '100px', // Ajusta el ancho de la columna de acciones
                        className: 'dt-head-center dt-body-center'
                    }
                ],
                responsive: true
            });

            // Agregar evento para ver ficha de cliente
            $('#tablaClientes').on('click', '.btn-ficha', function () {
                // Obtiene la fila que contiene los datos del cliente
                $tr = $(this).closest('tr');

                // Obtiene el ID del cliente
                var idCliente = $tr.find("td:eq(0)").text();

                // Redirecciona a la página de ficha de cliente
                window.location.href = 'ficha_paciente.php?id=' + idCliente;
            });

            // Agregar evento para editar cliente
            $('#tablaClientes').on('click', '.btn-editar', function () {
                // Obtiene la fila que contiene los datos del cliente
                $tr = $(this).closest('tr');

                // Obtiene el ID del cliente
                var idCliente = $tr.find("td:eq(0)").text();

                // Redirecciona a la página de edición de cliente
                window.location.href = 'editar_cliente.php?id=' + idCliente;
            });

            // Agregar evento para eliminar cliente
            $('#tablaClientes').on('click', '.btn-borrar', function () {
                // Obtiene la fila que contiene los datos del cliente
                $tr = $(this).closest('tr');

                // Obtiene el ID del cliente
                var idCliente = $tr.find("td:eq(0)").text();
                var nombreCliente = $tr.find("td:eq(1)").text();
                var apellidoCliente = $tr.find("td:eq(2)").text();

                // Pregunta al usuario si desea eliminar el cliente
                if (confirm("¿Estás seguro de eliminar el cliente: " + nombreCliente + " " + apellidoCliente +" ?")) {
                    // Elimina el cliente
                    $.ajax({
                        url: '../assets/includes/eliminar_clientes.php',
                        type: 'POST',
                        data: { idCliente: idCliente },
                        success: function (response) {
                            // Verifica si se eliminó el cliente
                            if (JSON.parse(response).success) {
                                // Elimina la fila de la tabla
                                $tr.remove();
                            } else {
                                // Muestra un mensaje de error
                                alert(JSON.parse(response).message);
                            }
                        }
                    });
                }
            });

        });
    </script>
</body>
</html>
