<?php

error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}
include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener resultados de búsqueda de ordenes de estudio
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["idPaciente"])) {
    $idPaciente = $_POST["idPaciente"];
    $stmt = $conn->prepare("SELECT o.id_orden_estudio, c.nombre, c.apellido, o.fecha, o.observacion, u.id_usuario, u.nombre AS nombre_medico, u.apellido AS apellido_medico,
            GROUP_CONCAT(e.nombre_estudio SEPARATOR ', ') AS estudios
            FROM ordenes_estudios o
            JOIN clientes c ON o.id_cliente = c.id_cliente
            LEFT JOIN usuarios u ON o.id_usuario = u.id_usuario
            LEFT JOIN ordenes_estudios_estudios oe ON o.id_orden_estudio = oe.id_orden_estudio
            LEFT JOIN estudios_medicos e ON oe.id_estudio = e.id_estudio
            WHERE o.id_cliente = ?
            GROUP BY o.id_orden_estudio");
    $stmt->bind_param("s", $idPaciente);
    $stmt->execute();
    $resultadosOrdenes = array();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $estudios = !empty($row['estudios']) ? explode(', ', $row['estudios']) : array();
        $resultadosOrdenes[] = array(
            'id_orden_estudio' => $row['id_orden_estudio'],
            'nombre' => $row['nombre'],
            'apellido' => $row['apellido'],
            'fecha' => $row['fecha'],
            'observacion' => $row['observacion'],
            'estudios' => $estudios,
            'id_usuario' => $row['id_usuario'],
            'nombre_medico' => $row['nombre_medico'],
            'apellido_medico' => $row['apellido_medico']
        );
    }
}

// Devolver resultados en formato JSON
header('Content-Type: application/json');
echo json_encode($resultadosOrdenes);
?>
