<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Incluir archivo de conexión
include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Verificar si se reciben los datos del formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['token'], $_POST['password'], $_POST['password'])) {
    $token = $_POST['token'];
    $nuevaContraseña = $_POST['password'];
    $confirmarContraseña = $_POST['password'];

    // Validar que las contraseñas coincidan
    if ($nuevaContraseña === $confirmarContraseña) {
        // Hash de la nueva contraseña
        $hashContraseña = password_hash($nuevaContraseña, PASSWORD_DEFAULT);

        // Actualizar la contraseña en la base de datos
        $sql = "UPDATE usuarios SET contrasena = ?, token_reset = NULL WHERE token_reset = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('ss', $hashContraseña, $token);

        if ($stmt->execute()) {
            // Contraseña actualizada con éxito, redirigir a la página de inicio de sesión o mostrar un mensaje
            header("Location: iniciar_sesion.php");
            exit();
        } else {
            // Error al actualizar la contraseña, redirigir o mostrar un mensaje de error
            echo "Error al actualizar la contraseña";
        }

        $stmt->close();
    } else {
        // Las contraseñas no coinciden, redirigir o mostrar un mensaje de error
        echo "Las contraseñas no coinciden";
    }

    $conn->close();
} else {
    // Datos del formulario no recibidos, redirigir o mostrar un mensaje de error
    echo "Datos del formulario no recibidos";
}
?>
