<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../assets/PHPMailer-master/src/Exception.php';
require '../assets/PHPMailer-master/src/PHPMailer.php';
require '../assets/PHPMailer-master/src/SMTP.php';

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

function generarToken()
{
    return bin2hex(random_bytes(32));
}

// obtener nombre y apellido del usuario
    $emailuser = $_POST["email"];
    $sql1 = "SELECT * FROM usuarios WHERE correo = ?";
    $stmt = $conn->prepare($sql1);
    $stmt->bind_param("s", $emailuser);
    $stmt->execute();
    $result1 = $stmt->get_result();
    $usuario = $result1->fetch_assoc();
    $nombre = $usuario['nombre'];
    $apellido = $usuario['apellido'];
    $nombreUsuario = $nombre . ' ' . $apellido;


function enviarCorreo($email, $token)
{
    $mail = new PHPMailer(true);

    try {
        // Configuración del servidor SMTP
        $mail->isSMTP();
        $mail->Host = 'dentox.com.py';
        $mail->SMTPAuth = true;
        $mail->Username = 'sistema@dentox.com.py';
        $mail->Password = '$istema$12345';
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        // Configuración del correo
        $mail->setFrom('sistema@dentox.com.py', 'Dentox - Sistema');
        $mail->addAddress($email);
        $mail->CharSet = 'UTF-8';

        // Contenido del correo
        $mail->isHTML(true);
        $mail->Subject = 'Recuperación de Contraseña';
        $mail->Body = "<!DOCTYPE html>
            <html lang=\"es\">
            <head>
                <meta charset=\"UTF-8\">
                <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
                <title>Recuperación de Contraseña - Dentox</title>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                        font-size: 16px;
                        color: #333;
                        margin: 0;
                        padding: 20px;
                    }
                    
                    .logo {
                        display: block;
                        margin: 0 auto;
                        width: 100px;
                    }
                    
                    .container {
                        max-width: 600px;
                        margin: 0 auto;
                        background-color: #fff;
                        padding: 20px;
                        border-radius: 10px;
                    }
                    
                    .titulo {
                        font-size: 20px;
                        font-weight: bold;
                        margin-bottom: 10px;
                    }
                    
                    .texto {
                        margin-bottom: 20px;
                    }
                    
                    .boton {
                        background-color: #007bff;
                        color: #fff;
                        text-decoration: none;
                        padding: 10px 20px;
                        border-radius: 5px;
                        font-size: 16px;
                        font-weight: bold;
                        cursor: pointer;
                    }
                    
                    .pie {
                        margin-top: 20px;
                        text-align: center;
                        font-size: 12px;
                        color: #999;
                    }
                </style>
            </head>
            <body>
                <div class=\"container\">
                    <img src=\"https://dentox.com.py/sistema/assets/images/Dentox.png\" class=\"logo\" alt=\"Dentox\" width=300px>
                    <h1 class=\"titulo\">Recuperación de Contraseña</h1>
                    <p class=\"texto\">Hola, para restablecer tu contraseña, haz clic en el siguiente enlace:</p>
                    <a href=\"http://dentox.com.py/sistema/pages/restablecer_contraseña.php?token=$token\" class=\"boton\">Restablecer Contraseña</a>
                    <p class=\"pie\">Si no has solicitado este cambio, ignora este mensaje.</p>
                </div>
            </body>
            </html>";
        $mail->send();

        return true;
    } catch (Exception $e) {
        return false;
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST["email"];

    // Verificar si el correo existe en la base de datos
    $sql = "SELECT * FROM usuarios WHERE correo = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $usuario = $result->fetch_assoc();

        // Generar token
        $token = generarToken();
        
        // Almacenar token en la base de datos
        $sqlUpdateToken = "UPDATE usuarios SET token_reset = ?, token_reset_expira = DATE_ADD(NOW(), INTERVAL 1 HOUR) WHERE id_usuario = ?";
        $stmtUpdateToken = $conn->prepare($sqlUpdateToken);
        $stmtUpdateToken->bind_param("si", $token, $usuario['id_usuario']);
        $stmtUpdateToken->execute();

        if ($stmtUpdateToken->affected_rows > 0) {
            // Enviar correo con el enlace de recuperación
            if (enviarCorreo($email, $token)) {
                echo "<script>
                alert('Se ha enviado un correo con las instrucciones para restablecer tu contraseña.');
                window.location.href = 'iniciar_sesion.php';
                </script>";    
            } else {
                echo "<script>
                alert('Error al enviar el correo. Inténtalo de nuevo más tarde.');
                </script>";
            }
        } else {
            echo "<script>
                alert('Error al generar el token. Inténtalo de nuevo más tarde.');
                </script>";
        }
    } else {
        echo "<script>
                alert('El correo ingresado no está registrado.');
                </script>";
    }        

    $stmt->close();
} else {
    echo json_encode(["success" => false, "error" => "Método no permitido."]);
}

$conn->close();
?>
