<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

session_start();

if (!isset($_SESSION["nombre_usuario"])) {
    header("Location: iniciar_sesion.php");
    exit();
}

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require '../assets/PHPMailer-master/src/Exception.php';
require '../assets/PHPMailer-master/src/PHPMailer.php';
require '../assets/PHPMailer-master/src/SMTP.php';


include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Verificar si hay algún error en la conexión
if ($conn->connect_error) {
    die("Error de conexión: " . $conn->connect_error);
}


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $idOrdenEstudio = $_POST["id_orden_estudio"];
    $idCliente = $_POST["id_cliente"];
    

    $consulta_correo = "SELECT contacto_email FROM clientes WHERE id_cliente = ?";
    $stmtCorreo = $conn->prepare($consulta_correo);
    $stmtCorreo->bind_param("i", $idCliente);
    $stmtCorreo->execute();
    $resultCorreo = $stmtCorreo->get_result();
    $correo = $resultCorreo->fetch_assoc();




    // Directorio donde se almacenarán los resultados médicos
    $directorioResultados = "../assets/resultados_medicos/";

    // Verificar si el directorio existe, si no, crearlo
    if (!file_exists($directorioResultados)) {
        mkdir($directorioResultados, 0777, true);
    }

    // Procesar la carga de archivos
    $resultadosCargados = 0;
    foreach ($_FILES["resultados"]["error"] as $key => $error) {
        if ($error == UPLOAD_ERR_OK) {
            $nombreArchivo = basename($_FILES["resultados"]["name"][$key]);
            $rutaArchivo = $directorioResultados . $nombreArchivo;

            // Validar el tipo de archivo permitido
            $tiposPermitidos = ['application/pdf', 'image/jpeg', 'image/png'];
            $tipoArchivo = $_FILES["resultados"]["type"][$key];

            if (in_array($tipoArchivo, $tiposPermitidos)) {
                // Mover el archivo al directorio de resultados médicos
                if (move_uploaded_file($_FILES["resultados"]["tmp_name"][$key], $rutaArchivo)) {
                    // Insertar información en la base de datos
                    $sqlInsertarResultado = "INSERT INTO resultados_medicos (id_orden_estudio, nombre_archivo, ruta_archivo, tipo_archivo) VALUES (?, ?, ?, ?)";
                    $stmtInsertarResultado = $conn->prepare($sqlInsertarResultado);
                    $stmtInsertarResultado->bind_param("isss", $idOrdenEstudio, $nombreArchivo, $rutaArchivo, $tipoArchivo);
                    $stmtInsertarResultado->execute();

                    if ($stmtInsertarResultado->affected_rows > 0) {
                        $resultadosCargados++;
                    }
                }
            } else {
                echo "Tipo de archivo no permitido: $tipoArchivo";
            }
        }
    }

    

    // Cerrar la conexión
    $conn->close();
    
    if ($resultadosCargados > 0){
        $mail = new PHPMailer(true);

        $correoDestinatario = $correo['contacto_email'];
        
        // Configuración del servidor SMTP
        $mail->isSMTP();
        $mail->Host = 'dentox.com.py';
        $mail->SMTPAuth = true;
        $mail->Username = 'sistema@dentox.com.py';
        $mail->Password = '$istema$12345';
        $mail->SMTPSecure = 'tls';
        $mail->Port = 587;

        // Configuración del correo
        $mail->setFrom('sistema@dentox.com.py', 'Dentox - Sistema');
        $mail->addAddress($correoDestinatario);
        $mail->CharSet = 'UTF-8';

        // Contenido del correo
        $mail->isHTML(true);
        $mail->Subject = 'Resultados de Estudios';
        $mail->Body = "<!DOCTYPE html>
            <html lang=\"es\">
            <head>
                <meta charset=\"UTF-8\">
                <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
                <title>Recuperación de Contraseña - Dentox</title>
                <style>
                    body {
                        font-family: Arial, sans-serif;
                        font-size: 16px;
                        color: #333;
                        margin: 0;
                        padding: 20px;
                    }
                    
                    .logo {
                        display: block;
                        margin: 0 auto;
                        width: 100px;
                    }
                    
                    .container {
                        max-width: 600px;
                        margin: 0 auto;
                        background-color: #fff;
                        padding: 20px;
                        border-radius: 10px;
                    }
                    
                    .titulo {
                        font-size: 20px;
                        font-weight: bold;
                        margin-bottom: 10px;
                    }
                    
                    .texto {
                        margin-bottom: 20px;
                    }
                    
                    .boton {
                        background-color: #007bff;
                        color: #fff;
                        text-decoration: none;
                        padding: 10px 20px;
                        border-radius: 5px;
                        font-size: 16px;
                        font-weight: bold;
                        cursor: pointer;
                    }
                    
                    .pie {
                        margin-top: 20px;
                        text-align: center;
                        font-size: 12px;
                        color: #999;
                    }
                </style>
            </head>
            <body>
                <div class=\"container\">
                    <img src=\"https://dentox.com.py/sistema/assets/images/Dentox.png\" class=\"logo\" alt=\"Dentox\" width=300px>
                    <h1 class=\"titulo\">Resultados de Estudios Solicitados</h1>
                    <p class=\"texto\">Hola, para verificar el resultado de los Estudios médicos solicitados dirigase al siguinte enlace</p>
                    <p> </p>
                    <a href=\"http://dentox.com.py/sistema/pages/resultados_pacientes.php\" class=\"boton\">Verificar Estudios Médicos</a>
                    <p class=\"pie\">Si no has solicitado estudios médicos, ignora este mensaje.</p>
                </div>
            </body>
            </html>";
        $mail->send();

    }

    if ($resultadosCargados > 0) {
        header("Location: cargar_resultados.php?error=resultados_cargados");
        exit();
    } else {
        header("Location: cargar_resultados.php?error=error_cargar_resultados");
        exit();
    }
} else {
    header("Location: cargar_resultados.php");
    exit();
}
?>
