<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Mostrar mensajes de error o éxito
$mensajeError = '';
$mensajeExito = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $cedulaPaciente = $_POST["cedulaPaciente"];

    // Buscar estudios del paciente agrupados por orden de estudios
    $sqlEstudiosPaciente = "SELECT oe.id_orden_estudio, oe.fecha,
                            GROUP_CONCAT(DISTINCT e.nombre_estudio SEPARATOR ' - ') AS estudios_solicitados,
                            GROUP_CONCAT(DISTINCT r.nombre_archivo SEPARATOR ', ') AS archivos_estudios,
                            GROUP_CONCAT(DISTINCT r.ruta_archivo SEPARATOR ', ') AS ubicaciones_archivos
                            FROM ordenes_estudios oe
                            JOIN ordenes_estudios_estudios oo ON oe.id_orden_estudio = oo.id_orden_estudio
                            JOIN estudios_medicos e ON oo.id_estudio = e.id_estudio
                            JOIN clientes c ON oe.id_cliente = c.id_cliente
                            LEFT JOIN resultados_medicos r ON oe.id_orden_estudio = r.id_orden_estudio
                            WHERE c.cedula = ?
                            GROUP BY oe.id_orden_estudio, oe.fecha
                            ORDER BY oe.id_orden_estudio";

    $stmtEstudiosPaciente = $conn->prepare($sqlEstudiosPaciente);
    $stmtEstudiosPaciente->bind_param("s", $cedulaPaciente);
    $stmtEstudiosPaciente->execute();
    $resultEstudiosPaciente = $stmtEstudiosPaciente->get_result();

    // Verificar si hay estudios asociados al paciente
    if ($resultEstudiosPaciente->num_rows > 0) {
        $estudiosPaciente = array();

        while ($filaEstudios = $resultEstudiosPaciente->fetch_assoc()) {
            $ordenEstudio = array(
                'id_orden_estudio' => $filaEstudios['id_orden_estudio'],
                'fecha' => $filaEstudios['fecha'],
                'estudios_solicitados' => $filaEstudios['estudios_solicitados'],
                'archivos_estudios' => $filaEstudios['archivos_estudios'],
                'ubicaciones_archivos' => $filaEstudios['ubicaciones_archivos']
            );

            // Agregar la orden de estudio al resultado final
            $estudiosPaciente[] = $ordenEstudio;
        }

        // Devolver el resultado en formato JSON
        header('Content-Type: application/json');
        echo json_encode($estudiosPaciente);
        exit();
    } else {
        // No se encontraron estudios asociados al paciente
        $mensajeError = 'No se encontraron estudios asociados al paciente con la cédula proporcionada.';
    }

    $stmtEstudiosPaciente->close();
}

// Mostrar mensajes de error o éxito
if ($mensajeError) {
    echo '<p style="color: red;">' . $mensajeError . '</p>';
}
if ($mensajeExito) {
    echo '<p style="color: green;">' . $mensajeExito . '</p>';
}
?>
