<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Consulta para obtener las facturas de compras
$sqlFacturasCompras = "SELECT fc.id_factura, p.id_proveedor, p.nombre_empresa, p.ruc, fc.fecha, fc.numero_factura, fc.importe_total
                      FROM facturas_compras fc
                      INNER JOIN proveedores p ON fc.id_proveedor = p.id_proveedor";

$resultadoFacturasCompras = ejecutarConsulta($sqlFacturasCompras);

// Crear un array para almacenar los resultados
$facturasCompras = array();

// Recorrer los resultados y agregarlos al array
while ($fila = $resultadoFacturasCompras->fetch_assoc()) {
    $facturasCompras[] = array(
        'id_factura' => $fila['id_factura'],
        'id_proveedor' => $fila['id_proveedor'],
        'nombre_empresa' => $fila['nombre_empresa'],
        'ruc' => $fila['ruc'],
        'fecha' => $fila['fecha'],
        'numero_factura' => $fila['numero_factura'],
        'importe_total' => $fila['importe_total']
    );
    
}

// Devolver el array en formato JSON
echo json_encode($facturasCompras);

// Cerrar la conexión
$conn->close();
?>
