<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}
include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

try{
    // obtener la fecha y contar la cantidad de citas por fecha
    $sql = "SELECT a.id_agendamiento,c.id_cliente AS id_paciente, c.nombre AS nombre_cliente, c.apellido AS apellido_cliente, u.nombre AS nombre_usuario, 
            u.apellido AS apellido_usuario, a.fecha_cita, a.hora_cita, a.nota, e.nombre_estado, e.id_estado
            FROM agendamientos a
            JOIN clientes c ON a.id_cliente = c.id_cliente
            JOIN usuarios u ON a.id_usuario = u.id_usuario
            JOIN estados_agendamientos e ON a.id_estado = e.id_estado";
    $result = ejecutarConsulta($sql);
    $citas = array();
    while ($row = $result->fetch_assoc()) {
        $citas[] = array(
            'fecha_cita' => $row['fecha_cita'],
            'nombre_cliente' => $row['nombre_cliente'],
            'apellido_cliente' => $row['apellido_cliente'],
            'nombre_usuario' => $row['nombre_usuario'],
            'apellido_usuario' => $row['apellido_usuario'],
            'hora_cita' => $row['hora_cita'],
            'id_paciente'=> $row['id_paciente'],
        );
        
    }
    // Devolver los datos en formato JSON
    header('Content-Type: application/json');
    echo json_encode($citas);
}
catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
