<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}
include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}
try{
// Obtener datos de agendamientos desde la base de datos
$sql = "SELECT a.id_agendamiento, c.nombre AS nombre_cliente, c.apellido AS apellido_cliente, u.nombre AS nombre_usuario, u.apellido AS apellido_usuario, a.fecha_cita, a.hora_cita, a.nota, e.nombre_estado, e.id_estado
        FROM agendamientos a
        JOIN clientes c ON a.id_cliente = c.id_cliente
        JOIN usuarios u ON a.id_usuario = u.id_usuario
        JOIN estados_agendamientos e ON a.id_estado = e.id_estado";

$agendamientos = array();
$result = ejecutarConsulta($sql);

while ($row = $result->fetch_assoc()) {
    $agendamientos[] = array(
        'id_agendamiento' => $row['id_agendamiento'],
        'nombre_cliente' => $row['nombre_cliente'],
        'apellido_cliente' => $row['apellido_cliente'],
        'nombre_usuario' => $row['nombre_usuario'],
        'apellido_usuario' => $row['apellido_usuario'],
        'fecha_cita' => $row['fecha_cita'],
        'hora_cita' => $row['hora_cita'],
        'nota' => $row['nota'],
        'id_estado' => $row['id_estado'], 
        'nombre_estado' => $row['nombre_estado']
    );

}

// Devolver los datos en formato JSON
header('Content-Type: application/json');
echo json_encode($agendamientos);
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}

?>
