<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén el ID del orden de estudio a eliminar
    $idOrdenEstudio = $_POST["id_orden_estudio"];

    try {
        // Desactivar temporalmente la verificación de clave externa
        $sqlDesactivarFK = "SET FOREIGN_KEY_CHECKS=0";
        ejecutarConsulta($sqlDesactivarFK);

        // Eliminar los registros relacionados en la tabla resultados_medicos
        $sqlEliminarResultados = "DELETE FROM resultados_medicos WHERE id_orden_estudio = $idOrdenEstudio";
        ejecutarConsulta($sqlEliminarResultados);

        // Ejemplo de eliminación en la base de datos
        $sqlEliminarOrdenEstudio = "DELETE FROM ordenes_estudios WHERE id_orden_estudio = $idOrdenEstudio";
        if (ejecutarConsulta($sqlEliminarOrdenEstudio)) {
            // Devuelve una respuesta JSON indicando éxito
            echo json_encode(array("success" => true));
            exit();
        } else {
            // Devuelve una respuesta JSON indicando error
            echo json_encode(array("success" => false, "message" => "Error al eliminar la orden y sus resultados"));
            exit();
        }
    } catch (Exception $e) {
        // Volver a activar la verificación de clave externa
        $sqlActivarFK = "SET FOREIGN_KEY_CHECKS=1";
        ejecutarConsulta($sqlActivarFK);

        // Lanzar excepción
        throw $e;
    }
} else {
    // Si no es una solicitud POST, redirige a la página de facturas de compras
    header("Location: ficha_paciente.php");
    exit();
}

?>
