<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Verificar si la solicitud es de tipo POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Verificar si se proporcionó un ID de archivo válido
    if (isset($_POST["idArchivo"])) {
        $idArchivo = $_POST["idArchivo"];

        // Incluir archivo de conexión a la base de datos
        include '../assets/includes/conexion.php';

        // Crear una instancia de la clase de conexión
        $conexionDB = new ConexionDB();
        $conn = $conexionDB->conectar();

        // Verificar si hay algún error en la conexión
        if ($conn->connect_error) {
            die("Error de conexión: " . $conn->connect_error);
        }

        // Obtener la ruta del archivo y eliminarlo del servidor
        $sqlObtenerArchivo = "SELECT ruta_archivo FROM resultados_medicos WHERE id_resultado = ?";
        $stmtObtenerArchivo = $conn->prepare($sqlObtenerArchivo);
        $stmtObtenerArchivo->bind_param("i", $idArchivo);
        $stmtObtenerArchivo->execute();
        $stmtObtenerArchivo->store_result();

        // Verificar si se encontró el archivo en la base de datos
        if ($stmtObtenerArchivo->num_rows > 0) {
            $stmtObtenerArchivo->bind_result($rutaArchivo);
            $stmtObtenerArchivo->fetch();
            
            // Eliminar el archivo del servidor si existe
            if (file_exists($rutaArchivo)) {
                unlink($rutaArchivo);
            }

            // Eliminar el registro de la base de datos
            $sqlEliminarArchivo = "DELETE FROM resultados_medicos WHERE id_resultado = ?";
            $stmtEliminarArchivo = $conn->prepare($sqlEliminarArchivo);
            $stmtEliminarArchivo->bind_param("i", $idArchivo);

            if ($stmtEliminarArchivo->execute()) {
                // Devolver una respuesta JSON indicando éxito
                echo json_encode(array("success" => true));
                exit();
            } else {
                // Devolver una respuesta JSON indicando error
                echo json_encode(array("success" => false, "message" => "Error al eliminar el archivo de la base de datos"));
                exit();
            }

            // Cerrar la conexión
            $stmtEliminarArchivo->close();
        } else {
            // Si no se encontró el archivo en la base de datos, devolver un mensaje de error
            echo json_encode(array("success" => false, "message" => "No se encontró el archivo en la base de datos"));
            exit();
        }

        // Cerrar la conexión
        $stmtObtenerArchivo->close();
        $conn->close();
    } else {
        // Si no se proporcionó un ID de archivo válido, devolver un mensaje de error
        echo json_encode(array("success" => false, "message" => "No se proporcionó un ID de archivo válido"));
        exit();
    }
} else {
    // Si la solicitud no es de tipo POST, devolver un mensaje de error
    echo json_encode(array("success" => false, "message" => "Acceso no permitido"));
    exit();
}
?>
