<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// funcion obtener cuentas contables
function obtenerCuentasContables()
{
    $sql = "SELECT * FROM cuenta_contable";
    return ejecutarConsulta($sql);
}

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <title>Dentox - Cuentas Contables</title>
    <!-- Tus enlaces CSS existentes -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Cuentas Contables</h2>
                            <a href="agregar_cuenta.php">
                                <button type="button" class="btn btn-primary" href="agregar_cuenta">Agregar Cuenta Contable</button>
                            </a>
                        </div>
                        <div class="card-body table-responsive">
                            <?php
                            // Obtener la lista de estudios médicos
                            $result = obtenerCuentasContables();

                            // Verificar si hay resultados
                            if ($result->num_rows > 0) {
                                echo "<table id='tablaCuentaContable' class='table'>
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Nombre</th>
                                                <th>Código</th>

                                                <th>Acciones</th>
                                            </tr>
                                        </thead>
                                        <tbody>";
                                // Recorrer los resultados
                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>
                                            <td>" . $row["id_cuenta"] . "</td>
                                            <td>" . $row["nombre_cuenta"] . "</td>
                                            <td>" . $row["codigo_cuenta_contable"] . "</td>

                                            
                                            <td>
                                                <a href='#' class='btn-editar' title='Editar'>
                                                    <i class='fa fa-edit'></i>
                                                </a>
                                                <a href='#' class='btn-borrar' title='Borrar'>
                                                    <i class='fa fa-minus' style='color:red;'></i>
                                                </a>
                                            </td>
                                            
                                        </tr>";
                                }

                                echo "</tbody></table>";
                            } else {
                                echo "<p>No hay cuentas contables.</p>";
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Agrega el script de DataTables -->
    <script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.html5.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.dataTables.min.css">
    <script>
        $(document).ready(function () {
            // Inicializar el DataTable y personalizar la disposición de los elementos
            $('#tablaCategoriaEstudio').DataTable({
                dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                    "<'row'<'col-md-12'tr>>" +
                    "<'row'<'col-md-6'i><'col-md-6'p>>",
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
                },
                buttons: [
                    {
                        extend: 'excelHtml5',
                        text: 'Exportar a Excel',
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    
                ],
                columnDefs: [
                    {
                        targets: -1,
                        width: '100px', // Ajusta el ancho de la columna de acciones
                        className: 'dt-head-center dt-body-center'
                    }
                ],
                responsive: true
            });

            // Agregar evento para editar estudio médico
            $('#tablaCuentaContable').on('click', '.btn-editar', function () {
                // Obtiene la fila que contiene los datos del estudio médico
                $tr = $(this).closest('tr');

                // Obtiene el ID del estudio médico
                var idCuenta = $tr.find("td:eq(0)").text();

                // Redirecciona a la página de edición de estudio médico
                window.location.href = 'editar_cuenta_contable.php?id=' + idCuenta;
            });

                    // Agregar evento para eliminar estudio médico
            $('#tablaCuentaContable').on('click', '.btn-borrar', function () {
                // Obtiene la fila que contiene los datos del estudio médico
                $tr = $(this).closest('tr');

                // Obtiene el ID del estudio médico
                var idCuenta = $tr.find("td:eq(0)").text();
                var nombreCuenta = $tr.find("td:eq(1)").text();

                // Muestra un mensaje de confirmación para eliminar el estudio médico
                var eliminar = confirm("¿Estás seguro de eliminar la cuenta contable: " + nombreCuenta + "?");

                // Agrega la lógica para la eliminación del estudio médico
                // Ejemplo:
                if (eliminar) {
                    $.ajax({
                        type: 'POST',
                        url: '../assets/includes/eliminar_cuenta_contable.php',
                        data: { idCuenta: idCuenta },
                        success: function (response) {
                            // Agrega la lógica para manejar la respuesta
                            alert('Cuenta contable eliminada Exitosamente.');
                            location.reload();
                        },
                        error: function () {
                            // Muestra un mensaje de error en caso de fallo
                            alert('Error en la solicitud AJAX para eliminar el estudio médico.');
                        }
                    });
                }
            });

        });
    </script>

