<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

?>


<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Tus enlaces CSS existentes -->

    <!-- Enlace para FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <!-- Enlace para Bootstrap -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Ajustes Generales</h2>
                        </div>
                        <div class="card-body text-center">
                            <h4>Configura los ajustes generales de la aplicación.</h4>
                            <div class="row row-cols-1 row-cols-md-4 g-1">
                                <div class="col">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <i class="fas fa-users fa-3x mb-3"></i>
                                            <h5 class="card-title">Ver Usuarios</h5>
                                            <br>
                                            <a href="usuarios.php" class="btn btn-primary">Ir</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <i class="fas fa-cogs fa-3x mb-3"></i>
                                            <h5 class="card-title">Configurar Roles</h5>
                                            <br>
                                            <a href="roles.php" class="btn btn-primary">Ir</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <i class="fas fa-tags fa-3x mb-3"></i>
                                            <h5 class="card-title">Configurar Categorias de Clientes</h5>
                                            <a href="categoria_cliente.php" class="btn btn-primary">Ir</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <i class="fas fa-calendar fa-3x mb-3"></i>
                                            <h5 class="card-title">Configurar Estados de la Agenda</h5>
                                            <a href="estado_agendamiento.php" class="btn btn-primary">Ir</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <i class="fas fa-stethoscope fa-3x mb-3"></i>
                                            <h5 class="card-title">Ver Registros de las Consultas Médicas</h5>
                                            <br>
                                            <a href="consulta_medica.php" class="btn btn-primary">Ir</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <i class="fas fa-file-medical fa-3x mb-3"></i>
                                            <h5 class="card-title">Categorias de Estudios</h5>
                                            <br><br>
                                            <a href="categoria_estudios.php" class="btn btn-primary">Ir</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <i class="fas fa-file-medical fa-3x mb-3"></i>
                                            <h5 class="card-title">Registros de los tipos de Estudios</h5>
                                            <br>
                                            <a href="estudios_medicos.php" class="btn btn-primary">Ir</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="card h-100">
                                        <div class="card-body">
                                            <i class="fas fa-closed-captioning fa-3x mb-3"></i>
                                            <h5 class="card-title">Cuentas Contables</h5>
                                            <br><br>
                                            <a href="cuentas_contables.php" class="btn btn-primary">Ir</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>
</body>
</html>

