function obtener_citas() {
    return new Promise((resolve, reject) => {
        fetch('../pages/obtener_citas.php')
            .then(response => response.json())
            .then(data => {
                console.log("Citas de fetch", data);
                resolve(data);  // Resuelve la promesa con los datos obtenidos
            })
            .catch(error => {
                console.error(error);
                reject(error);  // Rechaza la promesa con el error
            });
    });
}

document.addEventListener('DOMContentLoaded', async function () {
    var today = moment().format('YYYY-MM-DD');
    var events = await obtener_citas();
    events = events.map(evento => {
        // Parsea la fecha y la hora con Moment.js
        var startDateTime = moment(`${evento.fecha_cita} ${evento.hora_cita}`);
        
        // Suma 30 minutos a la hora de inicio para obtener la hora de finalización
        var endDateTime = startDateTime.clone().add(45, 'minutes');

        return {
            // title: evento.nombre_cliente + " " + evento.apellido_cliente + " - Médico: " + evento.nombre_usuario + " " + evento.apellido_usuario,
            title: evento.nota_cita,
            start: evento.fecha_cita+"T"+evento.hora_cita,
            end: endDateTime.format('YYYY-MM-DDTHH:mm:ss'),
            // agregar para redirigir a la ficha del paciente
            // url: `../pages/ficha_paciente.php?id=${evento.id_paciente}`,
        }
    });
    console.log("Citas de evento", events);
    
    $('#calendar').fullCalendar({
        header: {
            left: 'prevYear,prev,next,nextYear today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay,listMonth'
        },
        defaultDate: today,
        selectable: true,
        select: function (start, end, jsEvent, view) {
            var selectedDay = start.format('YYYY-MM-DD');
            updateSelectedDayInfo(selectedDay);
        },
        events
        ,
        eventClick: function (event){
            console.log("evento clic", event);
        },
        lang: 'es',
        buttonText: {
            today: 'Hoy',
            month: 'Mes',
            agendaDay: 'Día',
            week: 'Semana',
            list: 'Lista'
        },
        monthNames: [
            'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
            'Julio', 'Agosto', 'Setiembre', 'Octubre', 'Noviembre',
            'Diciembre'
        ],
        dayNames: [
            'Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes',
            'Sábado'
        ],
        dayNamesShort: [
            'Dom', 'Lu', 'Mar', 'Mié', 'Jue', 'Vie', 'Sáb',
        ],
        allDayText: 'Todo el día',
    });

    function updateTodayInfo(today, events) {
        var todayAppointments = getTodayAppointments(today, events);
        console.log("funcion update today info", todayAppointments);
        $('#appointmentsCount').text(todayAppointments.length);
    }

    function dayRender(date, cell, event) {
        var today = moment().format('YYYY-MM-DD');
        var todayAppointments = getTodayAppointments(today, event);
        console.log("funcion day render", todayAppointments);
        if (moment(date).isSame(today, 'day')) {
            cell.css("background-color", "#f5f5f5");
        }
        if (todayAppointments.length > 0) {
            cell.css("background-color", "#f5f5f5");
        }
    }

    function cargar_citas(events) {
        const tds = Array.from(document.querySelectorAll('td[data-date]'));
    
        tds.forEach(td => {
            const tdDate = td.getAttribute('data-date');
            const citas = events.filter(evento => tdDate === evento.fecha_cita);
    
            if (citas.length > 0) {
                citas.forEach((cita, index) => {
                    const p = document.createElement('p');
                    // p.innerHTML = `${cita.nombre_cliente} - ${cita.apellido_cliente}`;
                    p.innerHTML = `${cita.nota}`;
                    p.style.textAlign = "center";
                    
                    td.appendChild(p);
    
                    // Agrega un salto de línea después de cada párrafo, excepto en la última cita
                    if (index < citas.length - 1) {
                        td.appendChild(document.createElement('br'));
                    }
                });
            }
        });
    }
    
    
    
    function updateSelectedDayInfo(selectedDay) {
        var selectedDayAppointments = getDayAppointments(selectedDay);
        $('#selectedDayCount').text(selectedDayAppointments.length);
    
        // Limpiar la tabla antes de agregar nuevos datos
        $('#datos tbody').empty();
    
        // Imprimir todos los datos de las citas del día seleccionado
        selectedDayAppointments.forEach(function (event) {
            // Asumo que event tiene propiedades como 'nombre', 'apellido', 'hora_cita', etc.
            $('#datos tbody').append(
                "<tr>" +
                "<td>" + event.id_cita + "</td>" +
                "<td>" + event.nombre + " " + event.apellido + "</td>" +
                "<td>" + event.fecha_cita + "</td>" +
                "<td>" + event.hora_cita + "</td>" +
                "<td>" + event.telefono + "</td>" +
                "<td>" + event.correo + "</td>" +
                "<td>" + event.descripcion + "</td>" +
                "<td>" + event.cantidad_citas + "</td>" +
                "</tr>"
            );
        });
    }
    

    function getTodayAppointments(today, events) {
        return events.filter(function (evento) {
            console.log("Evento:", evento);
            return moment(evento.fecha_cita).isSame(today, 'day');
        });
    }

    function getDayAppointments(selectedDay) {
        return events.filter(function (evento) {
            return moment(evento.fecha_cita).isSame(selectedDay, 'day');
        });
    }
});
