<nav class="main-menu">

    <div class="settings">
        <?php
        // Verifica si hay una sesión activa y muestra el nombre de usuario con la imagen
        if (isset($_SESSION["nombre_usuario"])) {
            $nombreUsuario = $_SESSION["nombre_usuario"];

            // Obtener la ruta de la imagen del usuario desde la base de datos
            $sql = "SELECT i.nombre_archivo AS nombre_imagen
                    FROM usuarios u
                    LEFT JOIN imagenes i ON u.id_imagen = i.id_imagen
                    WHERE u.nombre_usuario = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("s", $nombreUsuario);
            $stmt->execute();
            $stmt->bind_result($imagenUsuario);
            $stmt->fetch();
            $stmt->close();
            //var_dump($imagenUsuario);

            // Verifica si se encontró una imagen y muestra la imagen y el nombre de usuario
            if ($imagenUsuario !== null) {

                $rutaImagen = "../assets/imagenes_usuarios/" . $imagenUsuario;
                echo "<p style='color: black; padding: 10px;'>$nombreUsuario</p>";
                echo "<img src=$rutaImagen style='width: 50px; height: 50px; border-radius: 50%;'>";
            } else {
                echo "<p style='color: black; padding: 10px;'>Bienvenido, $nombreUsuario</p>";
                // Puedes mostrar una imagen predeterminada si el usuario no tiene una asignada
                // echo "<img src='../imagenes_usuarios/imagen_predeterminada.jpg' alt='Imagen de usuario' style='width: 50px; height: 50px; border-radius: 50%;'>";
            }
        }
        ?>
    </div>



    <div class="scrollbar" id="style-1">
        <ul>
            <li>                                   
                <a href="../pages/dashboard.php">
                    <i class="fa fa-home fa-lg"></i>
                    <span class="nav-text">Inicio</span>
                </a>
            </li>   
           

            <li>                                 
                <a href="../pages/medicos.php">
                    <i class="fa fa-user-doctor"></i>
                    <span class="nav-text">Médicos</span>
                </a>
            </li>   
            <li>
                <a href="../pages/clientes.php">
                    <i class="fa fa-hospital-user"></i>
                    <span class="nav-text">Pacientes</span>
                </a>
            </li>
            <li>
                <a href="../pages/seguro_medico.php">
                    <i class="fa fa-house-medical"></i>
                    <span class="nav-text">Seguros Médicos</span>
                </a>
            </li>
            <li>
                <a href="../pages/proveedores.php">
                    <i class="fa fa-truck"></i>
                    <span class="nav-text">Proveedores</span>
                </a>
            </li>
            <li>
                <a href="../pages/cargar_resultados.php">
                    <i class="fa fa-file-waveform"></i>
                    <span class="nav-text">Cargar Resultados</span>
                </a>
            </li> 
            <li>
                <a href="../pages/facturas_compras.php">
                    <i class="fa fa-shop"></i>
                    <span class="nav-text">Compras</span>
                </a>
            </li> 
            <li>
                <a href="../pages/facturas_ventas.php">
                    <i class="fa fa-store"></i>
                    <span class="nav-text">Ventas</span>
                </a>
            </li>
            <li>
                <a href="../pages/cobranzas.php">
                    <i class="fa fa-hand-holding-dollar"></i>
                    <span class="nav-text">Cobranzas</span>
                </a>
            </li> 
            <li>
                <a href="../pages/ajustes_generales.php">
                    <i class="fa fa-gear" style="color: blue;"></i>
                    <span class="nav-text" style="color: blue;">Adm. Sistema</span>
                </a>
            </li>   
        </ul>
        <ul class="logout">
            <li>
                <a href="../pages/cerrar_sesion.php">
                    <i class="fa fa-sign-out fa-lg" style="color: red;"></i>
                    <span class="nav-text" style="color: red;">Cerrar Sesión</span>
                </a>
            </li>  
        </ul>
    </div>
</nav>
