<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Función para obtener la lista de bancos
function obtenerListaBancos()
{
    global $conn;
    $listaBancos = array();

    $sqlBancos = "SELECT id_banco, nombre_banco FROM bancos";
    $resultBancos = ejecutarConsulta($sqlBancos);

    while ($rowBanco = $resultBancos->fetch_assoc()) {
        $listaBancos[] = $rowBanco;
    }

    return $listaBancos;
}

$conceptoPago = '';
$importeTotal = 0;
$id_factura = 0;


// obtener el id del usuario mediante consulta
$sqlidusuario = "SELECT id_usuario FROM usuarios WHERE nombre_usuario = '" . $_SESSION["nombre_usuario"] . "'";
$resultadoidusuario = $conn->query($sqlidusuario);

if ($resultadoidusuario->num_rows > 0) {
    while ($row = $resultadoidusuario->fetch_assoc()) {
        $idUsuariosearch = $row["id_usuario"];
    }
} else {
    echo "0 results";
}

// Verifica si se recibieron los datos de las facturas
if (isset($_GET['facturas'])) {
    // Obtiene y decodifica los datos de las facturas
    $facturasSeleccionadas = json_decode($_GET['facturas'], true);

    // Verifica si hay datos de facturas para mostrar en el formulario
    if (!empty($facturasSeleccionadas)) {
        // Puedes acceder a los datos de cada factura, por ejemplo:
        $primerFactura = $facturasSeleccionadas[0];

        // Aquí puedes utilizar los datos de la primera factura para llenar el formulario
        $id_factura = $primerFactura['id_factura'];
        $id_cliente = $primerFactura['id_cliente'];
        $nombre_paciente = $primerFactura['nombre_paciente'];
        $cedula_paciente = $primerFactura['cedula_paciente'];
        $numero_factura = $primerFactura['numero_factura'];
        $cuota = $primerFactura['cuota'];
        // agregar monto_cuota pero convertir a float porque se recibe como string, entonces quitar primero su separador de mil y luego convertir a float
        $monto_cuota = floatval(str_replace('.', '', $primerFactura['monto_cuota']));
        $condicion_factura = $primerFactura['condicion_factura'];

        // imprimir en consola para verificar que se obtiene el monto_cuota
        echo "<script>console.log('Debug Objects: " . $monto_cuota . "' );</script>";

        // Calcular el importe total como la suma de los montos de las cuotas
        $importeTotal = 0;
        $conceptoPago = '';

        foreach ($facturasSeleccionadas as $factura) {
            $importeTotal += floatval(str_replace('.', '', $factura['monto_cuota']));
            $importeInicial = number_format($importeTotal, 0, ',', '.');

            if ($factura['condicion_factura'] == 'Crédito') {
                $conceptoPago .= $factura['numero_factura'] . ' (cuota nro: ' . $factura['cuota'] . '), ';
            } else {
                $conceptoPago .= $factura['numero_factura'] . ', ';
            }
        }

        $saldo = $importeTotal;

        // Puedes usar estos datos para llenar tu formulario
    } else {
        // No hay datos de facturas para procesar
        echo "No se recibieron datos de facturas.";
    }
} else {
    // No se recibieron datos de facturas
    echo "No se recibieron datos de facturas.";
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Pagos</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body>

<?php include '../assets/includes/navegacion.php'; ?>

<main class="container">
    <section class="py-5">
        <div class="row justify-content-center">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <img src="../assets/images/Dentox.png" width="150" class="logo">
                        <h2 class="ms-4">Registro de Pagos</h2>
                    </div>
                    <div class="card-body">

                        <!-- Mostrar datos del paciente -->
                        <div class="container">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-4">
                                        <h3 style="color: #4664B5;">Datos del Paciente</h3>
                                        <hr width="100%" style="color: #999999;"/>
                                        <div class="mb-3">
                                            <label for="nombrePaciente">Nombre del Paciente</label>
                                            <input type="text" class="form-control" id="nombrePaciente" name="nombrePaciente" value="<?= $nombre_paciente ?>" disabled>
                                        </div>
                                        <div class="mb-3">
                                            <label for="cedulaPaciente">RUC o C.I: </label>
                                            <input type="text" class="form-control" id="cedulaPaciente" name="cedulaPaciente" value="<?= $cedula_paciente ?>" disabled>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-4">
                                        <!-- Datos del seguro -->
                                        <h3 style="color: #4664B5;">Datos del Pago</h3>
                                        <hr width="100%" style="color: #999999;"/>
                                        <div class="mb-3">
                                            <label for="fechaPago">Fecha de Pago</label>
                                            <input type="date" class="form-control" id="fechaPago" name="fechaPago" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="conceptoPago">Concepto de Pago</label>
                                            <input type="text" class="form-control" id="conceptoPago" name="conceptoPago" value="<?= $conceptoPago ?>" disabled>
                                        </div>
                                        <div class="mb-3">
                                            <label for="importeTotal">Importe Total</label>
                                            <input type="text" class="form-control" id="importeTotal" name="importeTotal" value="<?= $importeInicial ?>" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr width="100%" style="color: #999999;"/>
                        </div>

                        <!-- Sección para agregar las líneas de factura -->
                        <div class="mb-12">
                            <h3 style="color: #4664B5;">Detalle de Pago</h3>
                            <hr width="100%" style="color: #999999;"/>

                            <!-- Formulario y tabla para agregar/editar líneas de detalle de pago -->
                            <form id="formDetallePago">
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label for="formaPago" class="form-label">Forma de Pago</label>
                                        <select class="form-select" id="formaPago" name="formaPago" onchange="mostrarNombreBanco()" required>
                                            <option value="efectivo">Efectivo</option>
                                            <option value="tarjeta">Tarjeta</option>
                                            <option value="transferencia">Transferencia</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="importePago" class="form-label">Importe</label>
                                        <input type="number" class="form-control" id="importePago" name="importePago" required>
                                    </div>
                                    <div class="col-md-4" id="nombreBancoContainer" style="display: none;">
                                        <label for="nombreBanco" class="form-label">Nombre del Banco (solo para transferencia)</label>
                                        <select class="form-select" id="nombreBanco" name="nombreBanco">
                                            <option value="0" selected>Seleccionar banco</option>
                                            <?php
                                            // Consulta para obtener la información de los bancos
                                            $bancos = obtenerListaBancos();

                                            // Iterar sobre los resultados y construir las opciones del select
                                            foreach ($bancos as $rowBanco) {
                                                echo "<option value='{$rowBanco['id_banco']}'>{$rowBanco['nombre_banco']}</option>";
                                            }
                                            ?>
                                        </select>

                                    </div>
                                </div>
                                <div class="row mb-3">
                                    <!-- Campo de saldo -->
                                    <div class="col-md-4">
                                        <label for="saldo" class="form-label">Saldo</label>
                                        <input type="text" class="form-control" id="saldo" name="saldo" class="saldo" value="<?= $importeInicial ?>" disabled>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-primary" onclick="agregarLineaDetalle()">Agregar Línea de Pago</button>
                            </form>

                            <!-- Tabla para mostrar las líneas de detalle de pago -->
                            <table class="table mt-3">
                                <thead>
                                    <tr>
                                        <th>Forma de Pago</th>
                                        <th>Importe</th>
                                        <th>Nombre del Banco</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="detallePagoTableBody">
                                    <!-- La primera línea se completará automáticamente con el importe total -->
                                </tbody>
                            </table>
                        </div>
                        <button type="button" class="btn btn-primary" id="generar_recibo" onclick="generar_recibo()" style="display: none;">Guardar Recibo</button>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<footer class="container">
    <p style="text-align:center;">© Desarrollado por AyP</p>
</footer>

<script>
    // Variable para almacenar el importe total
    var importeTotal = <?= $importeTotal ?>;
    var saldo = <?= $saldo ?>; // Se agrega la variable saldo
    var formaPagoTexto = ''; // Variable para almacenar el texto de las formas de pago

    // Función para agregar líneas a la tabla
    function agregarLineaDetalle() {
        // Obtener los valores del formulario
        var formaPago = document.getElementById('formaPago').value;
        var importePago = parseFloat(document.getElementById('importePago').value) || 0; // Convertir a número
        var nombreBancoId = document.getElementById('nombreBanco').value;

        // Validar que el importe no sea mayor al saldo y tiene que ser mayor a 0
        if (importePago > saldo || importePago <= 0) {
            alert('El importe no puede ser mayor al saldo o menor o igual a 0');
            return;
        }

        // Obtener el nombre del banco a partir del ID
        var nombreBanco = obtenerNombreBanco(nombreBancoId);

        // Restar el importe de la línea al saldo
        saldo -= importePago;

        // Crear una nueva fila en la tabla
        var nuevaLinea = document.createElement('tr');
        nuevaLinea.innerHTML = `
            <td>${formaPago}</td>
            <td>${importePago}</td>
            <td>${nombreBanco}</td>
            <td>
                <button type="button" class="btn btn-warning" onclick="editarLinea(this)">Editar</button>
                <button type="button" class="btn btn-danger" onclick="eliminarLinea(this)">Eliminar</button>
            </td>
        `;

        // Agregar la nueva línea al cuerpo de la tabla
        document.getElementById('detallePagoTableBody').appendChild(nuevaLinea);

        // Limpiar el formulario form detalle de pago
        document.getElementById('formDetallePago').reset();
        document.getElementById('saldo').value = saldo.toLocaleString('es-ES');

        if (saldo < importeTotal) {
            document.getElementById('generar_recibo').style.display = 'block';
        } else {
            document.getElementById('generar_recibo').style.display = 'none';
        }

        formaPagoTexto = obtenerFormaPagoTexto();
    }

    // Función para obtener el texto de la forma de pago desde la tabla
    function obtenerFormaPagoTexto() {
        var texto = '';
        var lineas = document.getElementById('detallePagoTableBody').getElementsByTagName('tr');

        for (var i = 0; i < lineas.length; i++) {
            var formaPago = lineas[i].getElementsByTagName('td')[0].innerText;
            var importePago = parseFloat(lineas[i].getElementsByTagName('td')[1].innerText) || 0;
            texto += formaPago + ' - ' + importePago.toLocaleString('es-ES') + ', ';
        }

        // Eliminar la última coma y espacio en blanco del texto
        return texto.slice(0, -2);
    }

    // Función para calcular el total de importes en las líneas
    function calcularTotalLineas() {
        var total = 0;
        var lineas = document.getElementById('detallePagoTableBody').getElementsByTagName('tr');
        for (var i = 0; i < lineas.length; i++) {
            total += parseFloat(lineas[i].getElementsByTagName('td')[1].innerText) || 0; // Convertir a número
        }
        console.log("Calculo de total", total);
        return total;
    }

    // Función para editar una línea
    function editarLinea(btn) {
        var fila = btn.closest('tr');
        document.getElementById('formaPago').value = fila.getElementsByTagName('td')[0].innerText;
        document.getElementById('importePago').value = fila.getElementsByTagName('td')[1].innerText;
        document.getElementById('nombreBanco').value = obtenerIdBanco(fila.getElementsByTagName('td')[2].innerText);
        fila.remove(); // Eliminar la fila editada
        // Actualizar el importe total
        saldo = importeTotal - calcularTotalLineas();
        document.getElementById('saldo').value = saldo.toLocaleString('es-ES');

        if (saldo < importeTotal) {
            document.getElementById('generar_recibo').style.display = 'block';
        } else {
            document.getElementById('generar_recibo').style.display = 'none';
        }
    }

    // Función para eliminar una línea
    function eliminarLinea(btn) {
        var fila = btn.closest('tr');
        fila.remove();

        // Actualizar el saldo
        saldo = importeTotal - calcularTotalLineas();
        // Actualizar el campo de saldo
        document.getElementById('saldo').value = saldo.toLocaleString('es-ES');

        if (saldo < importeTotal) {
            document.getElementById('generar_recibo').style.display = 'block';
        } else {
            document.getElementById('generar_recibo').style.display = 'none';
        }
    }

    // Función para obtener el nombre del banco a partir del ID
    function obtenerNombreBanco(idBanco) {
        var listaBancos = <?php echo json_encode(obtenerListaBancos()); ?>;
        var nombreBanco = '';

        for (var i = 0; i < listaBancos.length; i++) {
            if (listaBancos[i].id_banco == idBanco) {
                nombreBanco = listaBancos[i].nombre_banco;
                break;
            }
        }

        return nombreBanco;
    }

    // Función para obtener el ID del banco a partir del nombre
    function obtenerIdBanco(nombreBanco) {
        var listaBancos = <?php echo json_encode(obtenerListaBancos()); ?>;
        var idBanco = '';

        for (var i = 0; i < listaBancos.length; i++) {
            if (listaBancos[i].nombre_banco == nombreBanco) {
                idBanco = listaBancos[i].id_banco;
                break;
            }
        }

        return idBanco;
    }

    // Función para mostrar u ocultar el contenedor de banco
    function mostrarNombreBanco() {
        var formaPago = document.getElementById('formaPago').value;
        var nombreBancoContainer = document.getElementById('nombreBancoContainer');

        if (formaPago === 'transferencia') {
            nombreBancoContainer.style.display = 'block';
        } else {
            nombreBancoContainer.style.display = 'none';
        }
    }

    // Asignar la función al evento de cambio del campo de forma de pago
    document.getElementById('formaPago').addEventListener('change', mostrarNombreBanco);

    // Función para generar el recibo de pago y guardar en la tabla pagos
    function generar_recibo() {
        // Validar que haya líneas en la tabla de detalle de pago
        if (document.getElementById('detallePagoTableBody').childNodes.length === 0) {
            alert('No hay líneas de pago para generar el recibo.');
            return;
        }

        // Confirmar si el saldo es diferente de 0 y proceder con un pago parcial
        if (saldo !== 0) {
            if (!confirm('¿Desea proceder con un pago parcial, aun existe un saldo a cancelar?')) {
                return;
            }
        }

        // Obtener los valores del formulario
        var fechaPago = document.getElementById('fechaPago').value;
        var importeTotalRecibo = 0;
        var conceptoPago = document.getElementById('conceptoPago').value;

        for(var i = 0; i < document.getElementById('detallePagoTableBody').getElementsByTagName('tr').length; i++) {
            importeTotalRecibo += parseFloat(document.getElementById('detallePagoTableBody').getElementsByTagName('tr')[i].getElementsByTagName('td')[1].innerText);
        }

        // Obtener el texto de las formas de pago desde la tabla
        var formaPago = obtenerFormaPagoTexto();

        // Crear un objeto con los datos del recibo
        var reciboData = {
            fechaPago: fechaPago,
            importeTotal: importeTotalRecibo,
            formaPago: formaPago,
            concepto: conceptoPago,
            id_factura: <?= $id_factura ?>,
            id_usuario: <?= $idUsuariosearch ?>
        };

        console.log(reciboData);

        // Enviar el objeto a través de AJAX para guardar en la tabla pagos
        $.ajax({
            type: 'POST',
            url: 'guardar_pago.php',
            data: { reciboData: JSON.stringify(reciboData) },
            success: function (response) {
                // Alerta de éxito y redirección a la página de inicio
                alert('Recibo generado y guardado con éxito.');
                window.location.href = 'cobranzas.php';
            },
            error: function (error) {
                // Alerta de error en caso de fallo en la petición AJAX
                alert('Error al intentar generar y guardar el recibo.');
            }
        });
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2XofNefY6bs3P4F+6aLScJAq5a5fC5t9+RE" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/js/select2.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>

</body>
</html>
