<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}



// Procesar formulario de registro de consulta
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén los datos del formulario
    $fecha = $_POST["fecha"];
    $idCliente = $_POST["idCliente"];
    $idUsuario = $_POST["idUsuario"];
    $textoHistorial = $_POST["textoHistorial"];
    $motivo_consulta = $_POST["textoMotivo"];
   
    var_dump($_POST);

    // Realiza la inserción del historial médico en la base de datos
    $sql = "INSERT INTO historial_medico (id_cliente, motivo_consulta, texto_historial, fecha, id_medico) VALUES ('$idCliente', '$motivo_consulta','$textoHistorial', '$fecha', '$idUsuario')";
    
    if (ejecutarConsulta($sql)) {
        // Redirige con un mensaje de éxito
        header("Location: consulta_medica.php?success=Consulta registrada exitosamente");
        exit();
    } else {
        // Redirige con un mensaje de error
        header("Location: consulta_medica.php?error=Error al registrar la consulta");
        exit();
    }
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Registrar Consulta Médica</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <style>
        /* Ajuste de estilo para el campo de resumen */
        #textoHistorial {
            height: 150px;
        }
        #textoMotivo {
            height: 150px;
        }
    </style>
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Registrar Consulta Médica</h2>
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                <div class="mb-3">
                                    <label for="fecha">Fecha</label>
                                    <!-- Puedes usar un selector de fecha o un campo de entrada manual -->
                                    <input type="date" class="form-control" id="fecha" name="fecha" required>
                                </div>
                                <div class="mb-3">
                                    <label for="cliente">Buscar Cliente por Nombre o Cédula</label>
                                    <!-- Campo de búsqueda de clientes -->
                                    <input type="text" class="form-control" id="cliente" name="cliente" placeholder="Escribe el nombre o cédula" required>
                                    <div id="resultadosCliente"></div>
                                    <!-- Campo oculto para almacenar el ID del cliente seleccionado -->
                                    <input type="hidden" id="idCliente" name="idCliente" value="">
                                </div>
                                <div class="mb-3">
                                    <label for="medico">Buscar Médico por Nombre o RUC</label>
                                    <!-- Campo de búsqueda de proveedor -->
                                    <input type="text" class="form-control" id="medico" name="medico" placeholder="Escribe el nombre" required>
                                    <div id="resultadosMedicos"></div>
                                    <!-- Campo oculto para almacenar el ID del proveedor seleccionado -->
                                    <input type="hidden" id="idUsuario" name="idUsuario" value="">
                                </div>
                                <div class="mb-3">
                                    <label for="textoMotivo">Motivo de la consulta</label>
                                    <textarea class="form-control" id="textoMotivo" name="textoMotivo" placeholder="Introduce el motivo de la consulta" required></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="textoHistorial">Diagnostico Médico</label>
                                    <textarea class="form-control" id="textoHistorial" name="textoHistorial" placeholder="Introduce el diagnostico médico" required></textarea>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <a href="consulta_medica.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Registrar Consulta</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Agrega el script para buscar clientes -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function () {
            // Configura el evento de entrada en el campo de búsqueda de clientes
            $('#cliente').on('input', function () {
                // Obtiene el valor del campo de búsqueda
                var filtro = $(this).val();

                // Realiza la solicitud AJAX para buscar clientes
                $.ajax({
                    type: 'POST',
                    url: 'buscar_clientes.php',
                    data: { filtro: filtro },
                    success: function (response) {
                        // Muestra los resultados en el contenedor correspondiente
                        mostrarResultados(response);
                    },
                    error: function () {
                        // Muestra un mensaje de error en caso de falla en la solicitud AJAX
                        mostrarError();
                    }
                });
            });

            // Configura el evento de clic en un resultado de búsqueda de cliente
            $(document).on('click', '.resultado-cliente', function () {
                // Obtiene el ID del cliente seleccionado
                var idCliente = $(this).data('id');

                // Obtiene el nombre del cliente seleccionado
                var nombreCliente = $(this).data('nombre');

                // Muestra el nombre del cliente seleccionado
                $('#cliente').val(nombreCliente);

                // Almacena el ID del cliente seleccionado en el campo oculto
                $('#idCliente').val(idCliente);

                // Oculta el contenedor de resultados
                $('#resultadosCliente').html('');
            });

            // Función para mostrar resultados de búsqueda de clientes
            function mostrarResultados(resultados) {
                var resultadosHtml = '';

                // Construye el HTML para cada resultado
                resultados.forEach(function (resultado) {
                    resultadosHtml += '<div class="resultado-cliente" data-id="' + resultado.id_cliente + '" data-nombre="' + resultado.nombre + ' ' + resultado.apellido + '">' + resultado.nombre + ' ' + resultado.apellido + ' (' + resultado.cedula + ')</div>';
                });

                // Muestra los resultados en el contenedor correspondiente
                $('#resultadosCliente').html(resultadosHtml);
            }

            // Función para mostrar mensaje de error en caso de falla en la solicitud AJAX
            function mostrarError() {
                $('#resultadosCliente').html('<div class="resultado-error">Error al buscar clientes</div>');
            }

            // Configura el evento de entrada en el campo de búsqueda de proveedores
            $('#medico').on('input', function () {
                // Obtiene el valor del campo de búsqueda
                var filtroMedico = $(this).val();
                

                // Realiza la solicitud AJAX para buscar proveedores
                $.ajax({
                    type: 'POST',
                    url: 'buscar_medico.php',
                    data: { filtroMedico: filtroMedico },
                    success: function (response) {
                        // Muestra los resultados en el contenedor correspondiente
                        mostrarResultadosMedicos(response);
                        
                    },
                    error: function () {
                        // Muestra un mensaje de error en caso de falla en la solicitud AJAX
                        mostrarErrorMedico();
                    }
                });
            });

            // Configura el evento de clic en un resultado de búsqueda de proveedor
            $(document).on('click', '.resultado-medico', function () {
                // Obtiene el ID del proveedor seleccionado
                var idUsuario = $(this).data('id_usuario');


                // Obtiene el nombre del proveedor seleccionado
                var nombreUsuario = $(this).data('nombre');
                var apellidoUsuario = $(this).data('apellido');

                // Muestra el nombre del proveedor seleccionado
                $('#medico').val(nombreUsuario + ' ' + apellidoUsuario); 
                $('#idUsuario').val(idUsuario);

                // Oculta el contenedor de resultados
                $('#resultadosMedicos').html('');
            });


            // Función para mostrar resultados de búsqueda de proveedores
            function mostrarResultadosMedicos(resultadosMedicos) {
                var resultadosMedicosHtml = '';

                // Construye el HTML para cada resultado
                resultadosMedicos.forEach(function (resultadosMedicos) {
                    resultadosMedicosHtml += '<div class="resultado-medico" data-id_usuario="' + resultadosMedicos.id_usuario + '" data-nombre="' + resultadosMedicos.nombre + '" data-apellido="' + resultadosMedicos.apellido + '">' + resultadosMedicos.nombre + ' ' + resultadosMedicos.apellido + '</div>';
                });

                // Muestra los resultados en el contenedor correspondiente
                $('#resultadosMedicos').html(resultadosMedicosHtml);
            }

           // Función para mostrar mensaje de error en caso de falla en la solicitud AJAX
            function mostrarErrorMedicos() {
                $('#resultadosMedicos').html('<div class="resultado-error">Error al buscar proveedores</div>');
            }

        });
    </script>

</body>
</html>
