
<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
require_once '../assets/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener el ID del historial médico
$id_orden_estudio = $_GET["id"];


$sql = "SELECT oe.id_orden_estudio, oe.id_cliente, oe.id_usuario, oe.fecha, oe.observacion, 
        c.nombre AS nombre_paciente, c.apellido AS apellido_paciente, c.cedula AS cedula_paciente, c.fecha_nacimiento AS fecha_nacimiento, 
        u.nombre AS nombre_medico, u.apellido AS apellido_medico, oo.id_orden_estudio as id_orden_ordenes, oo.id_estudio as id_estudio_ordenes,
        e.nombre_estudio as nombre_estudio, e.precio as precio_estudio
        FROM ordenes_estudios oe
        JOIN ordenes_estudios_estudios oo ON oe.id_orden_estudio = oo.id_orden_estudio
        JOIN estudios_medicos e ON oo.id_estudio = e.id_estudio
        JOIN clientes c ON oe.id_cliente = c.id_cliente
        JOIN usuarios u ON oe.id_usuario = u.id_usuario
        WHERE oe.id_orden_estudio = '$id_orden_estudio'";

$ordenesEstudios = array();
$result = ejecutarConsulta($sql);


while ($row = $result->fetch_assoc()) {
    $ordenesEstudios[] = array(
        'id_orden_estudio' => $row['id_orden_estudio'],
        'id_cliente' => $row['id_cliente'],
        'id_usuario' => $row['id_usuario'],
        'fecha' => $row['fecha'],
        'observacion' => $row['observacion'],
        'nombre_paciente' => $row['nombre_paciente'],
        'apellido_paciente' => $row['apellido_paciente'],
        'cedula' => $row['cedula_paciente'],
        'fecha_nacimiento' => $row['fecha_nacimiento'],
        'nombre_medico' => $row['nombre_medico'],
        'apellido_medico' => $row['apellido_medico'],
        'id_orden_ordenes' => $row['id_orden_ordenes'],
        'id_estudio_ordenes' => $row['id_estudio_ordenes'],
        'nombre_estudio' => $row['nombre_estudio'],
        'precio_estudio' => $row['precio_estudio']
    );
}
function calcularEdad($fechaNacimiento)
{
    $fechaActual = date("Y-m-d");
    $diferencia = strtotime($fechaActual) - strtotime($fechaNacimiento);
    $edad = floor($diferencia / (60 * 60 * 24 * 365));
    return $edad;
}


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Informe de consulta</title>
</head>
<style>
body {

    /* background-image: url("../assets/images/recetario.png");
    background-repeat: no-repeat; */
    font-family: sans-serif;
    font-size: 16px;
}

#orden {
margin-top: 180px;
margin-left: 600px;
font-size: 25px; 

}
#cedula {
    margin-top: 18px;
    margin-left: 140px;    
}

#datos {
    margin-top: 10px;
    margin-left: 280px;    
}

#indicaciones {
    margin-top: 70px;
    margin-left: 100px;

    width: 500px;
    height: 600px;
    overflow: hidden;
    word-wrap: break-word;
    text-align: justify;


}

#firma {
    padding: 10px;
}

img {
    width: 100px;
}

h2 {
    font-size: 20px;
    font-weight: bold;
}

p {
    font-size: 16px;
}

.container {
    width: 21cm;
    min-height: 10cm;
}
</style>
<body style="background-image: url('../assets/images/orden_estudio.png'); background-repeat: no-repeat;">
    
    <div class="container">
        <div id="orden">
        <?php echo $id_orden_estudio ?>

        </div>
        <div id="datos">
            <br>
            <?php echo $ordenesEstudios[0]['nombre_paciente'] . " " . $ordenesEstudios[0]['apellido_paciente']; ?>
        </div>

        <div id="cedula">
            <?php
            echo $ordenesEstudios[0]['cedula'];
            //agregar espacios
            echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;";

            // Verifica si la fecha de nacimiento no es null antes de calcular la edad
            if ($ordenesEstudios[0]['fecha_nacimiento'] !== null) {
                echo calcularEdad($ordenesEstudios[0]['fecha_nacimiento']) . " años";
            } else {
                echo "No disponible";
            }
            ?>
        </div>

        <div id="indicaciones">
            <!-- iterar todos los estudios solicitados -->
            <?php foreach ($ordenesEstudios as $ordenEstudio) : ?>
                <div>
                    <br>
                    - <?php echo $ordenEstudio['nombre_estudio']; ?>
                </div>
            <?php endforeach; ?>

        </div>





        
    </div>
    <script>
        
        function descargarPDF() {
            // Contenido HTML que deseas convertir a PDF
            var html = document.documentElement.outerHTML;

            // Crea un objeto de la clase DOMPDF
            var dompdf = new Dompdf();

            // Establece las opciones (puedes ajustar según tus necesidades)
            var options = new Options();

            $options->set('isRemoteEnabled', true);
            $options->set('isPhpEnabled', true);
            $dompdf->setOptions($options);

            // Carga el HTML
            $dompdf->loadHtml($html);

            // Establece el tamaño de la página
            $dompdf->setPaper('A4', 'portrait', ['background' => 'url('../assets/images/recetario.png')']);
            // Genera el PDF
            $dompdf->render();

            // Descarga el PDF
            $dompdf->stream('informe.pdf');
        }
    </script>

    
</body>
</html>
