<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Consulta para obtener las facturas de ventas
$sqlFacturasVentas = "SELECT fv.id_factura, fv.id_usuario, fv.id_cliente, fv.condicion_venta, fv.plazo_en_dias, fv.estado, c.nombre AS nombre_paciente, c.apellido AS apellido_paciente, c.cedula as cedula_paciente, fv.fecha, fv.numero_factura, fv.importe_total, u.nombre_usuario
                      FROM facturas_ventas fv
                      INNER JOIN usuarios u ON fv.id_usuario = u.id_usuario
                      INNER JOIN clientes c ON fv.id_cliente = c.id_cliente";
$resultadoFacturasVentas = ejecutarConsulta($sqlFacturasVentas);

// Crear un array para almacenar los resultados
$facturasVentas = array();

// Recorrer los resultados y agregarlos al array
while ($fila = $resultadoFacturasVentas->fetch_assoc()) {
    $factura = array(
        'id_factura' => $fila['id_factura'],
        'id_usuario' => $fila['id_usuario'],
        'id_cliente' => $fila['id_cliente'],
        'nombre_paciente' => $fila['nombre_paciente'],
        'apellido_paciente' => $fila['apellido_paciente'],
        'cedula_paciente' => $fila['cedula_paciente'],
        'fecha' => $fila['fecha'],
        'numero_factura' => $fila['numero_factura'],
        'importe_total' => $fila['importe_total'],
        'nombre_usuario' => $fila['nombre_usuario'],
        'condicionFactura' => $fila['condicion_venta'],
        'plazo_en_dias' => $fila['plazo_en_dias'],
        'estado' => $fila['estado'],
        'atrasada' => false,  // Inicialmente, asumimos que no está atrasada
    );

    // Verificar si la factura está pendiente y tiene condición contado
    if ($factura['estado'] === 'pendiente' && $factura['condicionFactura'] === 'contado') {
        // Calcular la diferencia de días entre la fecha de la factura y la fecha actual
        $fechaActual = new DateTime();
        $fechaFactura = new DateTime($factura['fecha']);
        $diferenciaDias = $fechaActual->diff($fechaFactura)->days;

        // Actualizar la clave 'atrasada' según la diferencia de días
        $factura['atrasada'] = ($diferenciaDias > $factura['plazo_en_dias']);
    }

    $facturasVentas[] = $factura;
}

// Devolver el array en formato JSON
header('Content-Type: application/json');
echo json_encode($facturasVentas);

// Cerrar la conexión
$conn->close();
?>
