<?php
include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener resultados de búsqueda de consultas medicas
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["idPaciente"])) {
    $idPaciente = $_POST["idPaciente"];
    $stmt = $conn->prepare("SELECT h.id_historial, c.nombre, c.apellido, h.motivo_consulta, h.texto_historial, h.fecha, u.id_usuario, u.nombre AS nombre_medico, u.apellido AS apellido_medico
            FROM historial_medico h
            JOIN clientes c ON h.id_cliente = c.id_cliente
            LEFT JOIN usuarios u ON h.id_medico = u.id_usuario
            WHERE h.id_cliente = ?");
    $stmt->bind_param("s", $idPaciente);
    $stmt->execute();
    $resultadosConsultas = array();
    $result = $stmt->get_result();

    WHILE ($row = $result->fetch_assoc()) {
        $resultadosConsultas[] = array(
            'id_historial' => $row['id_historial'],
            'nombre' => $row['nombre'],
            'apellido' => $row['apellido'],
            'motivo_consulta' => $row['motivo_consulta'],
            'texto_historial' => $row['texto_historial'],
            'fecha' => $row['fecha'],
            'id_usuario' => $row['id_usuario'],
            'nombre_medico' => $row['nombre_medico'],
            'apellido_medico' => $row['apellido_medico']
        );
    }
} else {
    // Obtener la lista de consultas médicas
    $result = obtenerConsultasMedicas();
}

// Devolver resultados en formato JSON
header('Content-Type: application/json');
echo json_encode($resultadosConsultas);


?>
