<?php
// Archivo guardar_pago.php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// obtener el ultimo numero de recibo de la tabla pagos
$sqlUltimoNumero = "SELECT MAX(numero_recibo) AS ultimo_numero_recibo FROM pagos";
$resultadoUltimoNumero = ejecutarConsulta($sqlUltimoNumero);
$ultimoNumeroRecibo = 0;

if ($resultadoUltimoNumero) {
    $filaUltimoNumero = $resultadoUltimoNumero->fetch_assoc();
    $ultimoNumeroRecibo = $filaUltimoNumero['ultimo_numero_recibo'];
    $ultimoNumeroRecibo = $ultimoNumeroRecibo ? $ultimoNumeroRecibo + 1: 0;
}

// Verificar si se recibe la información del recibo
if (isset($_POST['reciboData'])) {
    // Obtener y decodificar los datos del recibo desde JSON
    $reciboData = json_decode($_POST['reciboData'], true);
    
    echo "Datos del recibo: " . print_r($reciboData, true);

    // Validar la existencia de los datos necesarios
    if (
        isset($reciboData['fechaPago'], $reciboData['importeTotal'], $reciboData['formaPago'], $reciboData['concepto'], $reciboData['id_factura'], $reciboData['id_usuario'])
    ) {
        // Generar un número de recibo automático
        $numeroRecibo = $ultimoNumeroRecibo;
        $id_cuota = 0;
        

        // Preparar la consulta SQL para insertar en la tabla pagos
        $sql = "INSERT INTO pagos (id_factura, id_cuota, forma_pago, concepto, importe_recibido, fecha_pago, numero_recibo)
                VALUES (?, ?, ?, ?, ?, ?, ?)";
        
        // Imprimir el SQL
        echo "SQL: " . $sql;

        // Preparar la declaración y vincular los parámetros
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("dsssdsi", $reciboData['id_factura'], $id_cuota, $reciboData['formaPago'], $reciboData['concepto'], $reciboData['importeTotal'], $reciboData['fechaPago'], $numeroRecibo);

        // Ejecutar la declaración
        if ($stmt->execute()) {
            // Éxito al guardar el recibo
            echo json_encode(["success" => true]);
        } else {
            // Error al guardar el recibo
            echo json_encode(["success" => false, "error" => "Error al intentar guardar el recibo."]);
        }

        // Cerrar la conexión y liberar recursos
        $stmt->close();
        $conn->close();
    } else {
        // Datos incompletos o incorrectos
        echo json_encode(["success" => false, "error" => "Datos incompletos o incorrectos."]);
    }
} else {
    // Datos del recibo no recibidos
    echo json_encode(["success" => false, "error" => "Datos del recibo no recibidos."]);
}
?>
