<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

include '../assets/includes/conexion.php';

if (
    isset($_POST['idUsuario'], $_POST['idCliente'], $_POST['fechaFactura'], $_POST['timbradoFactura'],
        $_POST['numeroFactura'], $_POST['totalFactura'], $_POST['condicionFactura'], $_POST['cuotas'])
) {
    $idUsuario = $_POST['idUsuario'];
    $idCliente = $_POST['idCliente'];
    $fechaFactura = $_POST['fechaFactura'];
    $timbradoFactura = $_POST['timbradoFactura'];
    $numeroFactura = $_POST['numeroFactura'];
    $totalFactura = $_POST['totalFactura'];
    $iva10 = $totalFactura / 11;
    $condicionFactura = $_POST['condicionFactura'];
    $cuotas = $_POST['cuotas'];

    $plazo_dias = 3;

    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    $sql = "INSERT INTO facturas_ventas (id_usuario, id_cliente, fecha, timbrado, numero_factura, importe_total, iva_10, condicion_venta, cuotas, plazo_en_dias) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $conn->prepare($sql);

    $stmt->bind_param("iissssdsss", $idUsuario, $idCliente, $fechaFactura, $timbradoFactura, $numeroFactura, $totalFactura, $iva10, $condicionFactura, $cuotas, $plazo_dias);

    if ($stmt->execute()) {
        $idFactura = $conn->insert_id;
        
        // Si la condición es a cuotas, generar las cuotas correspondientes
        if ($condicionFactura === 'Crédito' && $cuotas > 0) {
            // Calcular el monto de cada cuota
            $montoCuota = $totalFactura / $cuotas;

            // Insertar las cuotas en la tabla cuotas_factura
            for ($i = 0; $i < $cuotas; $i++) {
                $numeroCuota = $i + 1;
                $fechaVencimiento = date('Y-m-d', strtotime("+$i month", strtotime($fechaFactura)));
                $sqlCuota = "INSERT INTO cuotas_factura (id_factura, numero_cuota, fecha_vencimiento, monto_cuota) VALUES (?, ?, ?, ?)";
                $stmtCuota = $conn->prepare($sqlCuota);
                $stmtCuota->bind_param("iiss", $idFactura, $numeroCuota, $fechaVencimiento, $montoCuota);
                $stmtCuota->execute();
            }
        }
        
        echo json_encode(["success" => true, "idFactura" => $idFactura]);
    } else {
        echo json_encode(["success" => false, "message" => "Error al insertar la factura: " . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["success" => false, "message" => "Error: Datos incompletos o incorrectos."]);
}
?>
