<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Incluir el archivo de conexión
include '../assets/includes/conexion.php';

// Verificar si se recibieron los datos esperados
if (
    isset($_POST['idProveedor']) &&
    isset($_POST['fechaFactura']) &&
    isset($_POST['timbradoFactura']) &&
    isset($_POST['numeroFactura']) &&
    isset($_POST['importeTotal']) &&
    isset($_POST['iva10']) &&
    isset($_POST['iva5']) &&
    isset($_POST['excenta'])
) {
    // Obtener los datos del formulario
    $idProveedor = $_POST['idProveedor'];
    $fechaFactura = $_POST['fechaFactura'];
    $timbradoFactura = $_POST['timbradoFactura'];
    $numeroFactura = $_POST['numeroFactura'];
    $importeTotal = $_POST['importeTotal'];
    $iva10 = $_POST['iva10'];
    $iva5 = $_POST['iva5'];
    $excenta = $_POST['excenta'];

    // Crear una instancia de la clase de conexión
    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    // Preparar la consulta SQL para insertar en la tabla facturas_compras
    $sql = "INSERT INTO facturas_compras (id_proveedor, fecha, timbrado, numero_factura, importe_total, iva_10, iva_5, excenta) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

    // Preparar la sentencia
    $stmt = $conn->prepare($sql);

    // Vincular los parámetros
    $stmt->bind_param("isssdddi", $idProveedor, $fechaFactura, $timbradoFactura, $numeroFactura, $importeTotal, $iva10, $iva5, $excenta);

    // Ejecutar la sentencia
    if ($stmt->execute()) {
        // Obtener el ID de la factura recién insertada
        $idFactura = $conn->insert_id;

        // Devolver el ID de la factura como respuesta
        echo $idFactura;
    } else {
        // Manejar el error si la ejecución de la sentencia falla
        echo "Error al insertar la factura: " . $stmt->error;
    }

    // Cerrar la conexión y liberar recursos
    $stmt->close();
    $conn->close();
} else {
    // Si no se recibieron los datos esperados, devolver un mensaje de error
    echo "Error: Datos incompletos o incorrectos.";
}
?>
