<?php
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Función para obtener los roles
function obtenerRoles()
{
    $sql = "SELECT * FROM roles";
    return ejecutarConsulta($sql);
}

// Función para obtener los datos de un usuario por su ID
function obtenerDatosUsuario($idUsuario)
{
    global $conn;  // Asegúrate de que $conn esté disponible en este contexto

    $sql = "SELECT u.*, i.nombre_archivo AS nombre_imagen
            FROM usuarios u
            LEFT JOIN imagenes i ON u.id_imagen = i.id_imagen
            WHERE id_usuario = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idUsuario);
    $stmt->execute();

    $result = $stmt->get_result();
    return $result->fetch_assoc();
}

// Verificar si se ha proporcionado un ID de usuario
if (isset($_GET['id'])) {
    $idUsuario = $_GET['id'];
    $datosUsuario = obtenerDatosUsuario($idUsuario);
    // imprimir todos los datos del usuario
    //var_dump($datosUsuario);
} else {
    // Si no se proporciona un ID válido, redirige a la página de listar usuarios
    header("Location: usuarios.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Editar Usuario</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>

<main class="container">
    <section class="py-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <img src="../assets/images/Dentox.png" width="150" class="logo">
                        <h2 class="ms-4">Editar Usuario</h2>
                    </div>
                    <div class="card-body">
                        <form action="../assets/includes/procesar_actualizar_usuario.php" method="post" enctype="multipart/form-data">
                            <!-- Campos del formulario con los datos del usuario -->
                            <input type="hidden" name="idUsuario" value="<?php echo $datosUsuario['id_usuario']; ?>">
                            <div class="mb-3">
                                <label for="username">Usuario</label>
                                <input type="text" class="form-control" id="username" name="username" value="<?php echo $datosUsuario['nombre_usuario']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="nombre">Nombre</label>
                                <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo $datosUsuario['nombre']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="apellido">Apellido</label>
                                <input type="text" class="form-control" id="apellido" name="apellido" value="<?php echo $datosUsuario['apellido']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="email">Correo electrónico</label>
                                <input type="email" class="form-control" id="email" name="email" value="<?php echo $datosUsuario['correo']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="rol">Rol desempeñado:</label>
                                <select class="form-select" id="rol" name="rol" required>
                                    <?php
                                    // Obtener la lista de roles desde la base de datos
                                    $roles = obtenerRoles();

                                    // Verificar si hay roles
                                    if ($roles->num_rows > 0) {
                                        while ($rol = $roles->fetch_assoc()) {
                                            $selected = ($rol['id_rol'] == $datosUsuario['id_rol']) ? 'selected' : '';
                                            echo "<option value='{$rol['id_rol']}' $selected>{$rol['nombre_rol']}</option>";
                                        }
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="cedula">Nro. de Cédula</label>
                                <input type="cedula" class="form-control" id="cedula" name="cedula" value="<?php echo $datosUsuario['cedula']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="telefono">Teléfono</label>
                                <input type="telefono" class="form-control" id="telefono" name="telefono" value="<?php echo $datosUsuario['telefono']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="direccion">Dirección</label>
                                <input type="direccion" class="form-control" id="direccion" name="direccion" value="<?php echo $datosUsuario['direccion']; ?>" required>
                            </div>
                            <!-- Puedes agregar más campos según la estructura de tu base de datos -->
                            <div class="mb-3">
                                <label for="imagen">Imagen de perfil</label>
                            </div>
                            <div class="mb-3">
                                <?php
                                // Muestra la imagen actual si existe
                                if (!empty($datosUsuario['nombre_imagen'])) {
                                    $rutaImagenActual = '../assets/imagenes_usuarios/' . $datosUsuario['nombre_imagen'];
                                    echo "<img src='$rutaImagenActual' alt='Imagen actual de usuario' style='width: 100px; height: auto; margin-top: 10px;'>";
                                } else {
                                    echo "<p>No hay imagen asociada.</p>";
                                }
                                
                                ?>
                            </div>
                            <div class="mb-3">
                                <label for="imagen">Si desea actualizar la imagen, seleccione archivo</label>
                                <input type="file" class="form-control" id="imagen" name="imagen">
                            </div>
                            <div class="d-flex justify-content-between">
                                <a href="usuarios.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<?php include '../assets/includes/navegacion.php'; ?>
<footer class="container">
    <p style="text-align:center;">© Desarrollado por AyP</p>
</footer>

</body>
</html>
