<?php
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET["id"])) {
    // Obtén el ID del rol a editar
    $idRol = $_GET["id"];

    // Obtén la información del rol desde la base de datos
    $sql = "SELECT * FROM roles WHERE id_rol = $idRol";
    $resultado = ejecutarConsulta($sql);

    if ($resultado->num_rows > 0) {
        $rol = $resultado->fetch_assoc();
    } else {
        // Si no se encuentra el rol, redirige a la página de roles
        header("Location: ../../pages/roles.php");
        exit();
    }
} else {
    // Si no se proporciona un ID válido, redirige a la página de roles
    header("Location: ../../pages/roles.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Editar Rol</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Editar Rol</h2>
                        </div>
                        <div class="card-body">
                            <form action="../assets/includes/procesar_actualizar_rol.php" method="post">
                                <!-- Agrega los campos de edición del rol con los valores obtenidos de la base de datos -->
                                <input type="hidden" name="idRol" value="<?php echo $rol['id_rol']; ?>">
                                <div class="mb-3">
                                    <label for="nombreRol">Nombre del Rol</label>
                                    <input type="text" class="form-control" id="nombreRol" name="nombreRol" value="<?php echo $rol['nombre_rol']; ?>" required>
                                </div>
                                <!-- Otros campos de edición según la estructura de tu base de datos -->

                                <div class="d-flex justify-content-between">
                                    <a href="roles.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Actualizar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
<footer class="container">
    <p style="text-align:center;">© Desarrollado por AyP</p>
</footer>

</body>
</html>