<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión

if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Procesar formulario de edicion de estudio medico
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén el ID del estudio medico a editar
    $idEstudio = $_POST["idEstudio"];

    // Obtén los datos del formulario
    $nombreEstudio = $_POST["estudio_medico"];
    $precio = $_POST["precio"];

    // Actualiza el estudio medico en la base de datos utilizando una consulta preparada
    $sql = "UPDATE estudios_medicos SET nombre_estudio = ?, precio = ? WHERE id_estudio = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sii", $nombreEstudio, $precio, $idEstudio);
    $resultado = $stmt->execute();
    $stmt->close(); // Cierra el statement después de usarlo

    if ($resultado) {
        // Devuelve una respuesta JSON indicando éxito
        header("Location: ../pages/estudios_medicos.php");
        exit();
    } else {
        // Devuelve una respuesta JSON indicando error
        header("Location: ../pages/estudios_medicos.php");
        exit();
    }
}

// funcion para obtener datos de estudio medico
if ($_SERVER["REQUEST_METHOD"] == "GET") {
    // Obtén el ID del estudio medico a editar
    $idEstudio = $_GET["id"];

    // Elimina el estudio medico de la base de datos
    $sql = "SELECT * FROM estudios_medicos WHERE id_estudio = $idEstudio";
    $estudio_medico = array();
    $result = ejecutarConsulta($sql);

    while ($row = $result->fetch_assoc()) {
        $estudio_medico[] = array(
            'id_estudio' => $row['id_estudio'],
            'nombre_estudio' => $row['nombre_estudio'],
            'precio' => $row['precio']
        );
    }
} else {
    // Si no es una solicitud GET, redirige a la página de clientes
    header("Location: ../pages/estudio_medico.php");
    exit();
}



?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Registrar Estudio Médico</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Editar Estudio Médico</h2>
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                <input hidden type="text" name="idEstudio" value="<?php echo $estudio_medico[0]['id_estudio']; ?>">
                                <div class="mb-3">
                                    <label for="estudio_medico">Nombre del estudio médico</label>
                                    <input type="text" class="form-control" id="estudio_medico" name="estudio_medico" value="<?php echo $estudio_medico[0]['nombre_estudio']; ?>" required>

                                </div>
                                <div class="mb-3">
                                    <label for="precio">Precio</label>
                                    <input type="number" class="form-control" id="precio" name="precio" value="<?php echo $estudio_medico[0]['precio']; ?>" required>
                                </div>

                                <div class="mb-3">
                                    <a href="estudios_medicos.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Guardar</button>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    </body>
</html>