<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

session_start();

if (!isset($_SESSION["nombre_usuario"])) {
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

$id_factura = isset($_GET['id']) ? $_GET['id'] : '';


// Obtener datos de la factura
$sqlFactura = "SELECT f.id_factura, c.nombre AS nombre_paciente, c.apellido AS apellido_paciente, c.cedula, f.fecha, f.timbrado, f.numero_factura, f.importe_total
               FROM facturas_ventas f
               JOIN clientes c ON f.id_cliente = c.id_cliente
               WHERE f.id_factura = $id_factura";
$resultadoFactura = ejecutarConsulta($sqlFactura);
$factura = $resultadoFactura->fetch_assoc();
// formatear fecha
$fecha = date_create($factura['fecha']);
$fecha_formateada = date_format($fecha, 'd-m-Y');

// Obtener detalles de la factura
$sqlDetalles = "SELECT df.id_detalle, df.id_factura_venta, em.nombre_estudio, df.importe_total
                FROM detalle_factura_venta df
                JOIN estudios_medicos em ON df.id_estudios = em.id_estudio
                WHERE df.id_factura_venta = $id_factura";
$resultadoDetalles = ejecutarConsulta($sqlDetalles);

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Detalles de Factura de Venta</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h2>Detalles de Factura de Venta</h2>
                        </div>
                        <div class="row" style="padding: 20px;">
                            <div class="col-md-6">
                                <div class="mb-4">
                                    <br>
                                    <b><p><strong>Paciente:</strong></b> <?php echo $factura['nombre_paciente']  .' '. $factura['apellido_paciente']; ?></p>
                                    <b><p><strong>RUC:</strong></b> <?php echo $factura['cedula']; ?></p>
                                    <b><p><strong>Fecha:</strong></b> <?php echo $fecha_formateada; ?></p>
                                    <b><p><strong>Número de Factura:</strong></b> <?php echo $factura['numero_factura']; ?></p>
                                    <b><p><strong>Total Factura:</strong></b> <?php echo number_format($factura['importe_total'], 0, '.', '.'); ?></p>                                                
                                </div>
                            </div>
                        
                            <div style="padding: 20px;">
                                <h4>Detalles de la Factura</h4>
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Estudio Médico</th>
                                            <th>Importe</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ($detalle = $resultadoDetalles->fetch_assoc()) : ?>
                                            <tr>
                                                <td><?php echo $detalle['nombre_estudio']; ?></td>
                                                <td><?php echo number_format($detalle['importe_total'], 0, '.', '.'); ?></td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                                <div class="d-flex justify-content-between">
                                    <a href="facturas_ventas.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>
</body>
</html>
