<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtén la lista de clientes para el selector de filtro
$sqlPacientes = "SELECT id_cliente, nombre, apellido FROM clientes";
$resultadoPacientes = ejecutarConsulta($sqlPacientes);

$rutaImagen = '../assets/images/Dentox.png';
$contenidoImagen = file_get_contents($rutaImagen);
$imagenBase64 = base64_encode($contenidoImagen);
?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Cobros</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"
        rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.7.1/css/buttons.dataTables.min.css">

    <style>
        .dt-buttons.btn-group {
            margin-top: 10px;
        }

        .seleccionada {
            background-color: #f8d7da !important;
            /* Color de fondo rojo */
        }

        .totalMontoSeleccionado {
            font-weight: bold;
        }
    </style>
</head>

<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Cobros</h2>
                        </div>
                        <div class="card-body">
                            <!-- Selector de filtro por fecha -->
                            <label for="filtroFecha">Filtrar por Fecha:</label>
                            <input type="date" id="filtroFecha" name="filtroFecha">

                            <!-- Selector de filtro por paciente -->
                            <label for="filtroPaciente">Filtrar por Paciente:</label>
                            <select id="filtroPaciente" name="filtroPaciente">
                                <option value="">Todos</option>
                                <?php while ($pacientes = $resultadoPacientes->fetch_assoc()) : ?>
                                <option value="<?php echo $pacientes['id_cliente']; ?>">
                                    <?php echo $pacientes['nombre'] . ' ' . $pacientes['apellido']; ?>
                                </option>
                                <?php endwhile; ?>
                            </select>
                            <br><br>
                            <!-- Tabla de cobros -->
                            <table id="tablaCobros" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th hidden>ID Factura</th>
                                        <th hidden>ID Paciente</th>
                                        <th>Paciente</th>
                                        <th hidden>RUC</th>
                                        <th hidden>Fecha-orig</th>
                                        <th>Fecha</th>
                                        <th>Número de Factura</th>
                                        <th>Condición</th>
                                        <th>Cuota</th>
                                        <th>Fecha Vencimiento</th>
                                        <th>Días Atraso</th>
                                        <th hidden>Atrasado</th>
                                        <th>Monto Cuota</th>
                                        <th>Importe Total Factura</th>
                                        <th>Estado</th>
                                        <th hidden>ID Cuota</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Aquí se cargarán los registros de cobros -->
                                </tbody>
                            </table>
                            <!-- Elemento para mostrar el total del monto de las filas seleccionadas -->
                            <p>Total Importe a Pagar: <span id="totalMontoSeleccionado" class="totalMontoSeleccionado">0.00</span></p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Incluye las bibliotecas de DataTables, Buttons y jQuery -->
    <!-- jQuery en modo NoConflict -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        var $ = jQuery.noConflict();
    </script>

    <!-- Bootstrap JS -->
    <script
        src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-J1m8M0rpB9H5wX7I7FjRXPq8rkq7cS5eDhFoEEdgUKKqWUJAvi9MMg+uNqJwN2bx"
        crossorigin="anonymous"></script>

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Configuración del DataTable -->
    <script>
        $(document).ready(function () {
            

            var dataTable;

            $.ajax({
                url: 'obtener_fc_cuotas.php',
                dataType: 'json',
                success: function (data) {
                    var tableRows = '';

                    // Agrega las filas de facturas a la tabla
                    $.each(data['facturasPendientes'], function (index, factura) {

                        var fechaFacturaPartes = factura['fecha'].split('-');
                        var fechaFacturaFormateada = fechaFacturaPartes[2] + '-' + fechaFacturaPartes[1] + '-' + fechaFacturaPartes[0];

                        // Nueva columna para mostrar el importe total de la factura
                        var importeTotalFacturaColumn = '<td style="text-align:right;">' +
                            Math.round(factura['importe_total']).toLocaleString('es-ES') + '</td>';

                        // Columna de estado
                        var estadoColumn = '<td>' + (factura['estado'] === 'Pendiente' ? '<span class="badge bg-warning text-dark">Pendiente</span>' : '<span class="badge bg-success">Pagado</span>') + '</td>';

                        // Nueva columna para mostrar la cuota
                        var cuotaColumn = '<td></td>';

                        // Nueva columna para mostrar la fecha de vencimiento
                        var fechaVencimientoColumn = '<td></td>';

                        // Nueva columna para la selección (checkbox)
                        var seleccionColumn = '<td><input type="checkbox" class="seleccionar-fila"></td>';

                        // Verifica si la factura está atrasada y agrega la clase 'vencido' para resaltar en rojo
                        var estadoFilaClase = factura['atrasada'] > 0 ? ' class="vencido"' : '';

                        // Verifica si la fila está seleccionada y agrega la clase 'seleccionada' para resaltar
                        var seleccionClase = factura['seleccionada'] ? ' seleccionada' : '';

                        // Nueva columna para mostrar el monto de la cuota
                        //var montoCuotaColumn = '<td style="text-align:right;">' + Math.round(cuota['monto_cuota']).toLocaleString('es-ES') + '</td>';

                        // Si la condición es "Crédito", muestra las líneas de factura en lugar del importe total
                        if (factura['condicionFactura'] === 'Crédito') {
                            var cuotasRows = '';

                            // Recorre las cuotas de la factura
                            $.each(factura['cuotas'], function (index, cuota) {
                                // si la cuota tiene dias de atraso entonces se marca como vencida
                                var estadoCuotaClase = cuota['dias_atraso'] > 0 ? ' class="vencido"' : '';

                                // Nueva columna para mostrar la fecha de vencimiento de las cuotas
                                var fechaVencimientoCuotaPartes = cuota['fecha_vencimiento'].split('-');
                                var fechaVencimientoCuotaFormateada = fechaVencimientoCuotaPartes[2] + '-' + fechaVencimientoCuotaPartes[1] + '-' + fechaVencimientoCuotaPartes[0];
                                var fechaVencimientoCuotaColumn = '<td>' + fechaVencimientoCuotaFormateada + '</td>';

                                cuotasRows += '<tr' + estadoCuotaClase + seleccionClase + '>' +
                                    seleccionColumn +
                                    '<td hidden>' + factura['id_factura'] + '</td>' +
                                    '<td hidden>' + factura['id_cliente'] + '</td>' +
                                    '<td>' + factura['nombre_paciente'] + ' ' + factura['apellido_paciente'] + '</td>' +
                                    '<td hidden>' + factura['cedula_paciente'] + '</td>' +
                                    '<td hidden>' + factura['fecha'] + '</td>' +
                                    '<td>' + fechaFacturaFormateada + '</td>' +
                                    '<td>' + factura['numero_factura'] + '</td>' +
                                    '<td>' + factura['condicionFactura'] + '</td>' +
                                    '<td>' + cuota['numero_cuota'] + '</td>' +
                                    fechaVencimientoCuotaColumn +
                                    '<td>' + cuota['dias_atraso'] + '</td>' +
                                    '<td hidden>' + (cuota['atrasada'] > 0 ? 'Sí' : 'No') + '</td>' +
                                    '<td style="text-align:right;">' +
                                    Math.round(cuota['monto_cuota']).toLocaleString('es-ES') + '</td>' +
                                    importeTotalFacturaColumn +
                                    estadoColumn +
                                    '<td hidden>' + cuota['id_cuota'] + '</td>' +
                                    '</tr>';
                            });
                        } else {

                            // Ajusta las columnas para mostrar la información de la factura
                            cuotaColumn = '<td>' + factura['condicionFactura'] + '</td>';
                            // Nueva columna para mostrar la fecha de vencimiento
                            fechaVencimientoPartes = factura['fecha_vencimiento'].split('-');
                            fechaVencimientoFormateada = fechaVencimientoPartes[2] + '-' + fechaVencimientoPartes[1] + '-' + fechaVencimientoPartes[0];
                            fechaVencimientoColumn = '<td>' + fechaVencimientoFormateada + '</td>';
                            montoCuotaColumn = '<td style="text-align:right;">' +
                                Math.round(factura['importe_total']).toLocaleString('es-ES') + '</td>';
                        }

                        // Añade la fila a la tabla solo si la factura es contado
                        if (factura['condicionFactura'] === 'Contado') {
                            tableRows += '<tr' + estadoFilaClase + seleccionClase + '>' +
                                seleccionColumn +
                                '<td hidden>' + factura['id_factura'] + '</td>' +
                                '<td hidden>' + factura['id_cliente'] + '</td>' +
                                '<td>' + factura['nombre_paciente'] + ' ' + factura['apellido_paciente'] + '</td>' +
                                '<td hidden>' + factura['cedula_paciente'] + '</td>' +
                                '<td hidden>' + factura['fecha'] + '</td>' +
                                '<td>' + fechaFacturaFormateada + '</td>' +
                                '<td>' + factura['numero_factura'] + '</td>' +
                                '<td>' + factura['condicionFactura'] + '</td>' +
                                cuotaColumn +
                                fechaVencimientoColumn +
                                '<td>' + '-' + '</td>' +
                                '<td hidden>' + (factura['atrasada'] > 0 ? 'Sí' : 'No') + '</td>' +
                                montoCuotaColumn +
                                importeTotalFacturaColumn +
                                estadoColumn +
                                '<td hidden>' + '' + '</td>' +
                                '</tr>';

                        }

                        // Añade las filas de cuotas a la tabla
                        tableRows += cuotasRows;
                    });

                    // Agrega las filas de facturas a la tabla
                    $('#tablaCobros tbody').append(tableRows);

                    // Inicializa el DataTable
                    dataTable = $('#tablaCobros').DataTable({
                        // Configuración de DataTable
                        dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                            "<'row'<'col-md-12'tr>>" +
                            "<'row'<'col-md-6'i><'col-md-6'p>>",
                        language: {
                            url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                        },
                        buttons: [
                            // Configuración de botones para exportar a Excel y PDF
                            {
                                extend: 'excelHtml5',
                                text: '<i class="fa-solid fa-file-excel"></i> Exportar a Excel',
                                filename: 'cobros',
                                exportOptions: {
                                    columns: [2, 3, 5, 6, 7, 8, 9, 10, 11],
                                    header: {
                                        rows: [
                                            0, // Indica que la fila 0 se usará para el encabezado
                                            {
                                                style: {
                                                    fontSize: '18px',
                                                    bold: true,
                                                    color: '#FF0000' // Color opcional
                                                }
                                            }
                                        ]
                                    }
                                }
                            },
                            {
                                extend: 'pdfHtml5',
                                text: '<i class="fa-solid fa-file-pdf"></i> Exportar a PDF',
                                filename: 'cobros',
                                exportOptions: {
                                    columns: [2, 3, 5, 6, 7, 8, 9, 10, 11],
                                    header: true // Indica que se incluirá el encabezado en el archivo PDF
                                },
                                customize: function (doc) {
                                    // Agrega la imagen y el título al encabezado del archivo PDF
                                    var logoBase64 = '<?php echo $imagenBase64; ?>';

                                    doc.content.splice(0, 0, {
                                        image: 'data:image/png;base64,' + logoBase64,
                                        width: 100,
                                        alignment: 'left',
                                        margin: [10, 10, 0, 0] // Márgenes según sea necesario
                                    });
                                    doc.content.splice(1, 0, {
                                        text: '',
                                        style: 'header',
                                        alignment: 'center',
                                        margin: [0, 0, 0, 0], // Alinea verticalmente en el centro
                                        fontSize: 18,
                                        bold: true
                                    });
                                },
                            },
                            // agregar boton registrar pago, debe de estar inicialmente oculto
                            {
                                text: 'Registrar Pago',
                                action: function (e, dt, node, config) {
                                    // Obtiene las filas seleccionadas
                                    var filasSeleccionadas = dt.rows('.seleccionada').data();

                                    // Verifica si se han seleccionado filas
                                    if (filasSeleccionadas.length === 0) {
                                        alert('Debe seleccionar al menos una factura para registrar el pago.');
                                        return;
                                    }

                                    // Obtiene los datos de las filas seleccionadas
                                    var facturasSeleccionadas = [];
                                    filasSeleccionadas.each(function (value, index) {
                                        facturasSeleccionadas.push({
                                            id_factura: value[1],
                                            id_cliente: value[2],
                                            nombre_paciente: value[3],
                                            cedula_paciente: value[4],
                                            numero_factura: value[7],
                                            condicion_factura: value[8],
                                            cuota: value[9],
                                            monto_cuota: value[13],
                                            id_cuota: value[16],
                                        });
                                    });

                                    // rediriige a la pagina de registrar pago
                                    window.location.href = 'registrar_pago.php?facturas=' + JSON.stringify(facturasSeleccionadas);
                                }
                            }
                        ],
                    });

                    // Configura la lógica de selección de filas al hacer clic en un checkbox
                    $('#tablaCobros tbody').on('click', '.seleccionar-fila', function () {
                        var fila = $(this).closest('tr');
                        fila.toggleClass('seleccionada');

                        // actualiza el total del monto de las filas seleccionadas
                        var totalMontoSeleccionado = 0;
                        dataTable.rows('.seleccionada').every(function (rowIdx, tableLoop, rowLoop) {
                            var data = this.data();
                            montoCuota = parseFloat(data[13].replace(/\./g, '').replace(/\,/g, '.'));
                            totalMontoSeleccionado += montoCuota;
                            console.log(totalMontoSeleccionado);
                        });

                        $('#totalMontoSeleccionado').val(totalMontoSeleccionado);
                        $('#totalMontoSeleccionado').text(totalMontoSeleccionado.toLocaleString('es-ES'));
                    });

                    // Habilita el filtrado por fechas y pacientes
                    $('#filtroFecha, #filtroPaciente').on('change', function () {
                        // Aplica el filtro de fecha
                        var filtroFecha = $('#filtroFecha').val();
                        dataTable.columns(5).search(filtroFecha).draw();

                        // Aplica el filtro de paciente
                        var filtroPaciente = $('#filtroPaciente').val();
                        dataTable.columns(3).search(filtroPaciente).draw();
                    });

                    // Inicializa la funcionalidad del botón de registrar pago
                    $('button.dt-button:nth-child(3)').hide();
                }
            });
        });

        
    </script>
</body>

</html>
