<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Procesar formulario de registro de seguro
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén los datos del formulario
    $idCliente = $_POST["idCliente"];
    $idProveedor = $_POST["idProveedor"];
    $cobertura_medica = $_POST["cobertura_medica"];
    $fecha_inicio = $_POST["fecha_inicio"];
    $fecha_fin = $_POST["fecha_fin"];

    // Realiza la inserción del seguro médico en la base de datos
    $sql = "INSERT INTO seguro_medico (id_cliente, id_proveedor, cobertura_medica, fecha_inicio, fecha_fin) VALUES ('$idCliente', '$idProveedor', '$cobertura_medica', '$fecha_inicio', '$fecha_fin')";
    
    if (ejecutarConsulta($sql)) {
        // Redirige con un mensaje de éxito
        header("Location: seguro_medico.php?success=Seguro registrado exitosamente");
        exit();
    } else {
        // Redirige con un mensaje de error
        header("Location: seguro_medico.php?error=Error al registrar el seguro");
        exit();
    }
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Registrar Seguro Médico</title>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha384-dTveEnQIJCpMSIP3C4PSLdJveBU8lqF1ehmhtZ3Iu2vU9kQpZzlhPmWQihJfVw49" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Registrar Seguro Médico</h2>
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                
                            <div class="mb-3">
                                            <label for="buscar-paciente">Paciente</label>
                                                <br>
                                                <select id="buscar-paciente" class="btn btn-outline btn-lg" required>
                                                    <option value="" selected disabled>Buscar Paciente por Nombre o RUC</option>
                                                </select>
                                                <!-- Agrega un campo oculto para almacenar el idUsuario -->
                                                <input type="hidden" id="idCliente" name="idCliente">
                                </div>
                                <div class="mb-3">
                                            <label for="buscar-proveedor">Proveedor</label>
                                                <br>
                                                <select id="buscar-proveedor" class="btn btn-outline btn-lg" required>
                                                    <option value="" selected disabled>Buscar Proveedor por Nombre o RUC</option>
                                                </select>
                                                <!-- Agrega un campo oculto para almacenar el idUsuario -->
                                                <input type="hidden" id="idProveedor" name="idProveedor">
                                </div>
                                <div class="mb-3">
                                    <label for="cobertura_medica">Cobertura Médica</label>
                                    <input type="text" class="form-control" id="cobertura_medica" name="cobertura_medica" placeholder="Escribe la cobertura médica" required>
                                </div>                                
                                <div class="mb-3">
                                    <label for="fecha_inicio">Inicio Seguro</label>
                                    <!-- Puedes usar un selector de fecha o un campo de entrada manual -->
                                    <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio" required>
                                </div>
                                <div class="mb-3">
                                    <label for="fecha_fin">Fin de Vigencia</label>
                                    <!-- Puedes usar un selector de fecha o un campo de entrada manual -->
                                    <input type="date" class="form-control" id="fecha_fin" name="fecha_fin" required>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <a href="seguro_medico.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Registrar Consulta</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Agrega el script para buscar clientes -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2Xof8+cu6Qr5I5Ih0k5r4aFslw8Z5Gz0D93Q" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/js/select2.min.js"></script>
    <script>
        $(document).ready(function () {
            // Configura el evento de entrada en el campo de búsqueda de clientes
            $('#buscar-paciente').select2({
                    ajax: {
                        type: 'POST',
                        url: 'buscar_clientes.php',
                        delay: 250,
                        data: function (params) {
                            return {
                                filtro: params.term,
                            };
                        },
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (item) {
                                    return {
                                        text: item.nombre + ' ' + item.apellido,
                                        id: item.id_cliente,
                                        
                                    };
                                }),
                            };
                        },
                        cache: true,
                    },
                    placeholder: 'Buscar Paciente por Nombre o RUC',
                    minimumInputLength: 2,
                });

                // Agrega un evento change para capturar la selección
                $('#buscar-paciente').on('change', function (e) {
                    // Obtén el id_usuario seleccionado
                    var idPaciente = $(this).val();
                    
                    // Asigna el idUsuario al campo oculto
                    $('#idCliente').val(idPaciente);
                });

            // Configura el evento de entrada en el campo de búsqueda de proveedores
            $('#buscar-proveedor').select2({
                    ajax: {
                        type: 'POST',
                        url: 'buscar_proveedor.php',
                        delay: 250,
                        data: function (params) {
                            return {
                                filtroProveedor: params.term,
                            };
                        },
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (item) {
                                    return {
                                        text: item.nombre_empresa + ' (' + item.ruc + ')',
                                        id: item.id_proveedor,
                                        
                                    };
                                }),
                            };
                        },
                        cache: true,
                    },
                    placeholder: 'Buscar Paciente por Nombre o RUC',
                    minimumInputLength: 2,
                });

                // Agrega un evento change para capturar la selección
                $('#buscar-proveedor').on('change', function (e) {
                    // Obtén el id_usuario seleccionado
                    var idProveedor = $(this).val();
                    
                    // Asigna el idUsuario al campo oculto
                    $('#idProveedor').val(idProveedor);
                });
        });
    </script>

</body>
</html>
