<?php
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

// Incluye la conexión a la base de datos
include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Procesar el formulario cuando se envíe
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén los datos del formulario
    $idFactura = $_POST["id_factura"];
    $idCuota = $_POST["id_cuota"];
    $formaPago = $_POST["forma_pago"];
    $importeRecibido = $_POST["importe_recibido"];
    $fechaPago = $_POST["fecha_pago"];

    // Realiza las operaciones necesarias en la base de datos
    // ...

    // Ejemplo de inserción en la base de datos
    $sql = "INSERT INTO pagos (id_factura, id_cuota, forma_pago, importe_recibido, fecha_pago) VALUES ('$idFactura', '$idCuota', '$formaPago', '$importeRecibido', '$fechaPago')";

    if (ejecutarConsulta($sql)) {
        // Redirige a la página de éxito con un mensaje
        header("Location: registrar_pago.php?success=Pago registrado exitosamente");
        exit();
    } else {
        // Redirige a la página de error con un mensaje
        header("Location: registrar_pago.php?error=Error al registrar el pago");
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Registrar Pago</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <!-- Puedes agregar más enlaces a hojas de estilo según sea necesario -->
</head>
<body>

    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Registrar Pago</h2>
                        </div>
                        <div class="card-body">
                            <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
                                <!-- Puedes incluir campos ocultos para enviar datos importantes -->
                                <input type="hidden" name="id_factura" value="<?php echo $facturas[0]['id_factura']; ?>">
                                <input type="hidden" name="id_cuota" value="<?php echo $facturas[0]['cuota']; ?>">

                                <div class="mb-3">
                                    <label for="forma_pago">Forma de Pago:</label>
                                    <select name="forma_pago" id="forma_pago" class="form-control" required>
                                        <option value="Efectivo">Efectivo</option>
                                        <option value="Tarjeta">Tarjeta</option>
                                        <!-- Agrega más opciones según sea necesario -->
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label for="importe_recibido">Importe Recibido:</label>
                                    <input type="text" name="importe_recibido" id="importe_recibido" class="form-control" required>
                                </div>

                                <div class="mb-3">
                                    <label for="fecha_pago">Fecha de Pago:</label>
                                    <input type="date" name="fecha_pago" id="fecha_pago" class="form-control" required>
                                </div>

                                <div class="d-flex justify-content-between">
                                    <a href="javascript:history.go(-1)"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Registrar Pago</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

</body>
</html>
