<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtén la lista de estados_agendamientos para el selector de filtro por fecha
$sqlEstadosAgendamientos = "SELECT id_estado, nombre_estado FROM estados_agendamientos";
$resultadoEstadosAgendamientos = ejecutarConsulta($sqlEstadosAgendamientos);

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Agendamientos</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Agendamientos</h2>
                            <a href="registrar_agendamientos.php">
                            <button type="button" class="btn btn-primary" href="registrar_agendamientos.php"> 

                            Reservar Cita

                            </button>
                            </a>
                        </div>
                        <div class="card-body">
                            <!-- Selector de filtro por fecha -->
                            <label for="filtroFecha">Filtrar por Fecha:</label>
                            <input type="date" id="filtroFecha" name="filtroFecha">
                            <!-- Selector de filtro por estado -->
                            <label for="filtroEstado">Filtrar por Estado:</label>
                            <select id="filtroEstado" name="filtroEstado">
                                <option value="">Todos</option>
                                <?php while ($estado = $resultadoEstadosAgendamientos->fetch_assoc()) : ?>
                                    <option value="<?php echo $estado['id_estado']; ?>"><?php echo $estado['nombre_estado']; ?></option>
                                <?php endwhile; ?>
                            </select>
                            <!-- Tabla de agendamientos -->
                            <table id="tablaAgendamientos" class="table table-striped table-bordered" style="width:100%">
                                <thead>
                                    <tr>
                                        <th hidden>ID</th>
                                        <th>Paciente</th>
                                        <th>Médico</th>
                                        <th hidden>Fecha Original</th>
                                        <th>Fecha</th>
                                        <th>Hora</th>
                                        <th>Nota</th>
                                        <th hidden>Id Estado</th>
                                        <th>Estado</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Aquí se cargarán los registros de agendamientos -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Incluye las bibliotecas de DataTables y jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <!-- Configuración del DataTable -->
    <script>
        $(document).ready(function() {
            // Inicializa el DataTable
            $.ajax({
                    url: 'obtener_agendamientos.php',
                    dataType: 'json', // Especifica que la respuesta será en formato JSON
                    success: function (data) {
                        // Construye dinámicamente las filas de la tabla con los datos JSON
                        var tableRows = '';
                        $.each(data, function (index, row) {
                            // Dividimos la fecha en partes
                            const fechaPartes = row.fecha_cita.split('-');
                            
                            // Unimos las partes en el formato deseado
                            const fechaFormateada = fechaPartes[2] + '-' + fechaPartes[1] + '-' + fechaPartes[0]; 
                            tableRows += '<tr>' +
                                '<td hidden>' + row.id_agendamiento + '</td>' +
                                '<td>' + row.nombre_cliente + ' ' + row.apellido_cliente + '</td>' +
                                '<td>' + row.nombre_usuario + ' ' + row.apellido_usuario + '</td>' +
                                '<td hidden>' + row.fecha_cita + '</td>' +
                                '<td>' + fechaFormateada + '</td>' +
                                '<td>' + row.hora_cita + '</td>' +
                                '<td>' + row.nota + '</td>' +
                                '<td hidden>' + row.id_estado + '</td>' +
                                '<td>' + row.nombre_estado + '</td>' +
                                '<td><a href="actualizar_estado_agenda.php?id=' + row.id_agendamiento +'"><i class="fa fa-edit editar-agendamiento"></i></a></td>' +                               
                                '</tr>';    });

                        // Inserta las filas en la tabla de consultas médicas en la sección de Historial de Citas
                        $('#tablaAgendamientos tbody').html(tableRows);

                        // Inicializa DataTables
                        $('#tablaAgendamientos').DataTable({
                            dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                                "<'row'<'col-md-12'tr>>" +
                                "<'row'<'col-md-6'i><'col-md-6'p>>",
                            language: {
                                url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
                            }, 
                        });
                    },
                    error: function (error) {
                        console.log(error);
                    }

                    
                });
                // evento para filtrar por fecha
                $('#filtroFecha').on('change', function () {
                        // Obtiene el valor del filtro
                        const filtroFecha = $(this).val();

                        // Si el filtro no tiene valor, no se hace nada
                        if (filtroFecha === '') {
                             //reiniciar el datatable
                            $('#tablaAgendamientos').DataTable().destroy();
                            return;
                        }

                        // Filtra los registros de la tabla
                        $('#tablaAgendamientos').DataTable().column(3).search(filtroFecha).draw();
                    });

                // evento para filtrar por estado
                $('#filtroEstado').on('change', function () {
                        // Obtiene el valor del filtro
                        const filtroEstado = $(this).val();

                        // Si el filtro no tiene valor, no se hace nada
                        if (filtroEstado === 'Todos') {
                            //reiniciar el datatable
                            $('#tablaAgendamientos').DataTable().destroy();
                            return;
                        }

                        // Filtra los registros de la tabla
                        $('#tablaAgendamientos').DataTable().column(7).search(filtroEstado).draw();
                    });

                
            });
    </script>



</body>
</html>
