<?php
// Incluye la clase de conexión
include 'conexion.php';
ini_set('display_errors', 1);
error_reporting(E_ALL);


// Verifica si se recibieron datos por POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Comprobación de la conexión
    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    // Recupera los datos del formulario
    $username = $_POST["username"];
    $email = $_POST["email"];
    $nombre = $_POST["nombre"];
    $apellido = $_POST["apellido"];
    $cedula = $_POST["cedula"];
    $telefono = $_POST["telefono"];
    $direccion = $_POST["direccion"];
    $rol = $_POST["rol"];
    $password = $_POST["password"];
    $confirm_password = $_POST["confirmPassword"];

    //Validar que las contraseñas coincidan
    if ($password != $confirm_password) {
        echo "<script>alert('Las contraseñas no coinciden.'); history.back();</script>";
        exit();
    }

    // verifica si ya existe un usuario con la misma cedula o correo
    $sqlVerificarCedulaCorreo = "SELECT * FROM usuarios WHERE cedula = '$cedula' OR correo = '$email'";
    $resultVerificarCedulaCorreo = $conn->query($sqlVerificarCedulaCorreo);

    if ($resultVerificarCedulaCorreo->num_rows > 0) {
        echo "<script>alert('Ya existe un usuario con la misma cedula o correo.'); history.back();</script>";
        exit();
    }

    // Procesar la carga de la imagen
    if ($_FILES['imagen']['error'] == UPLOAD_ERR_OK) {
        $imagenTmpName = $_FILES['imagen']['tmp_name'];
        $imagenName = $_FILES['imagen']['name'];

        // Obtiene la extensión del archivo
        $extension = pathinfo($imagenName, PATHINFO_EXTENSION);

        // Verifica si la extensión es jpg o png
        if (strtolower($extension) == 'jpg' || strtolower($extension) == 'png') {
            // Mueve la imagen a la carpeta deseada (ajusta la ruta según tu estructura de carpetas)
            $rutaImagen = '../imagenes_usuarios/' . $imagenName;
            move_uploaded_file($imagenTmpName, $rutaImagen);

            // Inserta la información de la imagen en la tabla de imágenes
            $sqlInsertImagen = "INSERT INTO imagenes (nombre_archivo, fecha_subida) VALUES ('$imagenName', NOW())";
            $conn->query($sqlInsertImagen);

            // Obtiene el ID de la última imagen insertada
            $idImagen = $conn->insert_id;
        } else {
            // Si la extensión no es válida, emite un mensaje de error
            echo "<script>alert('Solo se permiten archivos JPG o PNG.'); history.back();</script>";
            exit();
        }
    } else {
        // Si no se proporcionó una imagen, asigna un valor predeterminado o NULL a $idImagen
        $idImagen = null;
    }


    // Hashea la contraseña
    $hashContrasena = password_hash($password, PASSWORD_DEFAULT);

    // Verifica si el correo electrónico ya está registrado
    $stmt = $conn->prepare("SELECT nombre_usuario FROM usuarios WHERE correo = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        // El correo electrónico ya está registrado
        echo "<script>alert('El correo electrónico ya está registrado.'); history.back();</script>";
        exit();
    } else {
        // Inserta un nuevo usuario en la base de datos
        $stmt = $conn->prepare("INSERT INTO usuarios (nombre_usuario, correo, contrasena, id_rol, nombre, apellido, cedula, telefono, direccion, id_imagen) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssssssssi", $username, $email, $hashContrasena, $rol, $nombre, $apellido, $cedula, $telefono, $direccion, $idImagen);

        // Comprobación de los datos del formulario
        if ($stmt->execute()) {
            // Registro exitoso
            echo "<script>alert('Usuario registrado exitosamente.'); window.location.href = '../../pages/usuarios.php';</script>";
            exit();
        } else {
            // Error al registrar el usuario
            echo "Error al registrar el usuario: " . $stmt->error;
        }
    }

    // Cierra la conexión a la base de datos
    $conexionDB->desconectar($conn);
} else {
    // Si alguien intenta acceder directamente a este script sin enviar datos por POST, redirige a la página de inicio
    header("Location: ../../pages/iniciar_sesion.php");
    exit();
}
?>
