<?php

// Incluye el archivo de conexión a la base de datos y cualquier otra configuración necesaria
include 'conexion.php';

// Crear un array para almacenar la respuesta
$response = array();

// Verifica si se ha recibido el idUsuario por POST
if (isset($_POST['idUsuario'])) {
    // Obtiene el idUsuario desde POST
    $idUsuario = $_POST['idUsuario'];

    // Realiza cualquier validación adicional que puedas necesitar antes de la eliminación

    // Realiza la eliminación del usuario en la base de datos
    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    // Prepara la consulta para eliminar el usuario
    $sql = "DELETE FROM usuarios WHERE id_usuario = ?";

    // Prepara la declaración
    $stmt = $conn->prepare($sql);

    // Vincula los parámetros
    $stmt->bind_param("i", $idUsuario);

    // Ejecuta la declaración
    if ($stmt->execute()) {
        // Éxito: la eliminación fue exitosa
        $response['success'] = true;
        $response['message'] = 'Usuario eliminado exitosamente.';
    } else {
        // Fallo: no se pudo eliminar el usuario
        $response['success'] = false;
        $response['message'] = 'Error al eliminar el usuario.';
    }

    // Cierra la declaración y la conexión
    $stmt->close();
    $conn->close();
} else {
    // Si no se proporcionó el idUsuario, devuelve un mensaje de error
    $response['success'] = false;
    $response['message'] = 'ID de usuario no proporcionado.';
}

// Devuelve la respuesta como JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
