<?php

// Incluye el archivo de conexión a la base de datos y cualquier otra configuración necesaria
include 'conexion.php';

// Crear un array para almacenar la respuesta
$response = array();

// Verifica si se ha recibido el idProveedor por POST
if (isset($_POST['idProveedor'])) {
    // Obtiene el idProveedor desde POST
    $idProveedor = $_POST['idProveedor'];

    // Realiza cualquier validación adicional que puedas necesitar antes de la eliminación

    // Realiza la eliminación del proveedor en la base de datos
    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    // Prepara la consulta para eliminar el proveedor
    $sql = "DELETE FROM proveedores WHERE id_proveedor = ?";

    // Prepara la declaración
    $stmt = $conn->prepare($sql);

    // Vincula los parámetros
    $stmt->bind_param("i", $idProveedor);

    // Ejecuta la declaración
    if ($stmt->execute()) {
        // Éxito: la eliminación fue exitosa
        $response['success'] = true;
        $response['message'] = 'Proveedor eliminado exitosamente.';
    } else {
        // Fallo: no se pudo eliminar el proveedor
        $response['success'] = false;
        $response['message'] = 'Error al eliminar el proveedor.';
    }

    // Cierra la declaración y la conexión
    $stmt->close();
    $conn->close();
} else {
    // Si no se proporcionó el idProveedor, devuelve un mensaje de error
    $response['success'] = false;
    $response['message'] = 'ID de proveedor no proporcionado.';
}

// Devuelve la respuesta como JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
