<?php
session_start();

if (!isset($_SESSION["nombre_usuario"])) {
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET["id_orden"]) && isset($_GET["nombre_archivo"])) {
    $idOrdenEstudio = $_GET["id_orden"];
    $nombreArchivo = $_GET["nombre_archivo"];

    // Obtener detalles del archivo
    $sqlDetallesArchivo = "SELECT nombre_archivo, ruta_archivo, tipo_archivo FROM resultados_medicos WHERE id_orden_estudio = ? AND nombre_archivo = ?";
    $stmtDetallesArchivo = $conn->prepare($sqlDetallesArchivo);
    $stmtDetallesArchivo->bind_param("is", $idOrdenEstudio, $nombreArchivo);
    $stmtDetallesArchivo->execute();
    $resultDetallesArchivo = $stmtDetallesArchivo->get_result();

    if ($resultDetallesArchivo->num_rows > 0) {
        $detallesArchivo = $resultDetallesArchivo->fetch_assoc();
    } else {
        // Archivo no encontrado
        header("Location: cargar_resultados.php?error=archivo_no_encontrado");
        exit();
    }

    $stmtDetallesArchivo->close();
} else {
    // Parámetros no proporcionados
    header("Location: cargar_resultados.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Ver Resultados</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h2>Detalles del Resultado Médico</h2>
                        </div>

                        <div class="card-body">
                            <?php if (isset($detallesArchivo)) : ?>
                                <p><strong>Nombre de Archivo:</strong> <?php echo $detallesArchivo["nombre_archivo"]; ?></p>
                                <p><strong>Tipo de Archivo:</strong> <?php echo $detallesArchivo["tipo_archivo"]; ?></p>
                                <p><strong>Ruta de Archivo:</strong> <?php echo $detallesArchivo["ruta_archivo"]; ?></p>

                                <!-- Agrega aquí cualquier otra información que desees mostrar -->

                                <a href="<?php echo $detallesArchivo["ruta_archivo"]; ?>" target="_blank" class="btn btn-primary">Ver Archivo</a>
                            <?php else : ?>
                                <p>Detalles no encontrados.</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>
</body>
</html>
