<?php

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Obtener resultados de estudios del paciente
function obtenerResultadosPaciente($cedulaPaciente)
{
    $urlObtenerResultados = 'obtener_resultados_paciente.php';
    
    // Realizar solicitud POST a obtener_resultados_pacientes.php
    $ch = curl_init($urlObtenerResultados);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(['cedulaPaciente' => $cedulaPaciente]));

    // Ejecutar la solicitud
    $response = curl_exec($ch);

    // Manejar errores de conexión
    if (curl_errno($ch)) {
        return null;
    }

    // Decodificar el JSON de la respuesta
    $resultadosPaciente = json_decode($response, true);

    // Cerrar la conexión cURL
    curl_close($ch);

    return $resultadosPaciente;
}

// Procesar el formulario de búsqueda
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $cedulaPaciente = $_POST["cedulaPaciente"];

    // Obtener resultados de estudios del paciente
    $resultadosPaciente = obtenerResultadosPaciente($cedulaPaciente);
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Tus enlaces CSS existentes -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
        /* Agrega un estilo para los títulos en negrita */
        .card-title {
            font-weight: bold;
        }
    </style>
</head>
<body>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">    
                            <h2 class="ms-4">Resultados de Estudios del Paciente</h2>
                        </div>
                        <div class="card-body">
                            <form method="post" action="">
                                <div class="mb-3">
                                    <label for="cedulaPaciente" class="form-label">Ingrese la cédula del paciente:</label>
                                    <input type="text" class="form-control" id="cedulaPaciente" name="cedulaPaciente" required>
                                </div>
                                <button type="button" class="btn btn-primary" onclick="buscarResultados()">Buscar Resultados</button>
                            </form>

                            <div id="resultadosContainer" class="mt-3"></div>

                            <script>
                                function buscarResultados() {
                                    var cedulaPaciente = $('#cedulaPaciente').val();

                                    // Realizar solicitud AJAX para obtener resultados
                                    $.ajax({
                                        type: 'POST',
                                        url: 'obtener_resultados_paciente.php',
                                        data: { cedulaPaciente: cedulaPaciente },
                                        dataType: 'json',
                                        success: function (resultados) {
                                            mostrarResultados(resultados);
                                        },
                                        error: function () {
                                            alert('Error al obtener los resultados del paciente.');
                                        }
                                    });
                                }

                                function mostrarResultados(resultados) {
                                    var resultadosContainer = $('#resultadosContainer');
                                    resultadosContainer.html('');

                                    if (resultados && resultados.length > 0) {
                                        resultados.forEach(function (ordenEstudio) {
                                            const fechaPartes = ordenEstudio.fecha.split('-');
                                            const fechaFormateada = fechaPartes[2] + '-' + fechaPartes[1] + '-' + fechaPartes[0];
                                            var tarjeta = '<div class="card mb-4">';
                                            tarjeta += '<div class="card-body">';
                                            tarjeta += '<h5 class="card-title">ID de Orden de Estudio: ' + ordenEstudio.id_orden_estudio + '</h5>';
                                            tarjeta += '<p class="card-title">Fecha de Orden de Estudio: ' + fechaFormateada + '</p>';

                                            if (ordenEstudio.estudios_solicitados) {
                                                tarjeta += '<p class="card-title">Estudios Solicitados: ' + ordenEstudio.estudios_solicitados + '</p>';
                                            }

                                            if (ordenEstudio.archivos_estudios && ordenEstudio.ubicaciones_archivos) {
                                                var archivosEstudios = ordenEstudio.archivos_estudios.split(', ');
                                                var ubicacionesArchivos = ordenEstudio.ubicaciones_archivos.split(', ');

                                                archivosEstudios.forEach(function (archivo, index) {
                                                    tarjeta += '<p class="card-text">';
                                                    tarjeta += '<strong>Nombre del Archivo:</strong> ' + archivo + ' ';
                                                    tarjeta += '<a href="' + ubicacionesArchivos[index] + '" target="_blank">Abrir Archivo</a>';
                                                    tarjeta += '</p>';
                                                });
                                            }

                                            tarjeta += '</div>';
                                            tarjeta += '</div>';
                                            resultadosContainer.append(tarjeta);
                                        });
                                    } else {
                                        resultadosContainer.html('<p>No se encontraron resultados asociados al paciente con la cédula proporcionada.</p>');
                                    }
                                }

                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Agrega el script de DataTables -->
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
</body>
</html>

