<?php
// Archivo restablecer_contraseña.php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Incluir archivo de conexión
include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Verificar si se recibe un token válido
if (isset($_GET['token'])) {
    $token = $_GET['token'];

    // Preparar la consulta SQL para validar el token
    $sql = "SELECT id_usuario, correo FROM usuarios WHERE token_reset = ?";
    
    // Preparar la declaración y vincular los parámetros
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $token);

    // Ejecutar la declaración
    $stmt->execute();

    // Obtener resultados
    $stmt->store_result();

    // Verificar si el token es válido
    if ($stmt->num_rows > 0) {
        // Token válido, permitir al usuario restablecer la contraseña
        ?>
        <!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Restablecer Contraseña</title>
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
        </head>
        <body>
            <main class="container">
                <section class="py-5">
                    <div class="row justify-content-center">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h2>Restablecer Contraseña</h2>
                                </div>
                                <div class="card-body">
                                    <!-- Aquí debes agregar un formulario HTML para que el usuario ingrese su nueva contraseña -->
                                    <form action="proceso_restablecer_contraseña.php" method="post">
                                        <div class="mb-3">
                                            <label for="password">Nueva Contraseña</label>
                                            <input type="password" class="form-control" id="password" name="password" required>
                                        </div>
                                        <input type="hidden" name="token" value="<?php echo $token; ?>">
                                        <button type="submit" class="btn btn-primary">Restablecer Contraseña</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </main>
        </body>
        </html>
        <?php
    } else {
        // Token no válido
        echo "Token no válido.";
    }

    // Cerrar la declaración
    $stmt->close();
} else {
    // No se proporcionó un token
    echo "Token no proporcionado.";
}

// Cerrar la conexión
$conn->close();
?>
