<?php

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}
include '../assets/includes/conexion.php';

// Mostrar mensajes de error
if (isset($_GET['error'])){
    $error = $_GET['error'];
    switch($error){
      case 'existente':
        $mensajeError = 'Ya existe un proveedor con el mismo nombre de empresa, RUC, o contacto.';
        break;
      case 'registro':
        $mensajeError = 'Error al registrar el proveedor.';
        break;
    }
}

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

?>


<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dentox - Registrar Proveedor</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">

</head>
<body>

  <main class="container">
    <section class="py-5">
      <div class="row justify-content-center">
        <div class="col-md-6">
          <div class="card">
            <div class="card-header d-flex align-items-center justify-content-between">
              <img src="../assets/images/Dentox.png" width="150" class="logo">
              <h2 class="ms-4">Registrar Proveedor</h2>
            </div>

            <div class="card-body">
              <!-- Mostrar mensaje de error -->
        <?php if (isset($mensajeError)) : ?>
            <div class="alert alert-danger" role="alert">
                <?php echo $mensajeError; ?>
            </div>
        <?php endif; ?>
              <form action="../assets/includes/procesar_registro_proveedor.php" method="post">
                <div class="mb-3">
                  <label for="nombre_empresa">Nombre de la Empresa</label>
                  <input type="text" class="form-control" id="nombre_empresa" name="nombre_empresa" placeholder="Introduce el nombre de la empresa" required>
                </div>
                <div class="mb-3">
                  <label for="ruc">RUC</label>
                  <input type="text" class="form-control" id="ruc" name="ruc" placeholder="Introduce el RUC" required>
                </div>
                <div class="mb-3">
                  <label for="contacto_nombre">Nombre de Contacto</label>
                  <input type="text" class="form-control" id="contacto_nombre" name="contacto_nombre" placeholder="Introduce el nombre de contacto" required>
                </div>
                <div class="mb-3">
                  <label for="contacto_telefono">Teléfono de Contacto</label>
                  <input type="text" class="form-control" id="contacto_telefono" name="contacto_telefono" placeholder="Introduce el teléfono de contacto">
                </div>
                <div class="mb-3">
                  <label for="contacto_email">Correo de Contacto</label>
                  <input type="email" class="form-control" id="contacto_email" name="contacto_email" placeholder="Introduce el correo de contacto">
                </div>
                
                <!-- Puedes agregar más campos según la estructura de tu base de datos -->

                <div class="d-flex justify-content-between">
                    
                    <a href="proveedores.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                    <button type="submit" class="btn btn-primary">Registrar</button>
                </div>

              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
  </main>
  <?php include '../assets/includes/navegacion.php'; ?>
  <footer class="container">
    <p style="text-align:center;">© Desarrollado por AyP</p>
  </footer>


</body>
</html>
