<?php
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();
// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener la lista de proveedores
function obtenerProveedores()
{
    $sql = "SELECT * FROM proveedores";
    return ejecutarConsulta($sql);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <!-- Tus enlaces CSS existentes -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Listado de Proveedores</h2>
                            <a href="registro_proveedor.php">
                            <button type="button" class="btn btn-primary" href="registro_proveedor.php"> 
                            Agregar Proveedor
                            </button>
                            </a>
                        </div>
                        <div class="card-body table-responsive">
                            <?php
                            // Obtener la lista de proveedores
                            $result = obtenerProveedores();

                            // Verificar si hay resultados
                            if ($result->num_rows > 0) {
                                echo "<table id='tablaProveedores' class='table'>
                                        <thead>
                                            <tr>
                                                <th hidden>ID</th>
                                                <th>Nombre Empresa</th>
                                                <th>RUC</th>
                                                <th>Contacto Nombre</th>
                                                <th>Contacto Teléfono</th>
                                                <th>Contacto Email</th>
                                                <th>Acciones</th>
                                            </tr>
                                        </thead>
                                        <tbody>";

                                while ($row = $result->fetch_assoc()) {
                                    echo "<tr>
                                            <td hidden>{$row['id_proveedor']}</td>
                                            <td>{$row['nombre_empresa']}</td>
                                            <td>{$row['ruc']}</td>
                                            <td>{$row['contacto_nombre']}</td>
                                            <td>{$row['contacto_telefono']}</td>
                                            <td>{$row['contacto_email']}</td>
                                            <td>
                                                <a href='#' class='btn-editar' title='Editar'>
                                                    <i class='fa fa-edit'></i>
                                                </a>
                                                <a href='#' class='btn-borrar' title='Borrar'>
                                                    <i class='fa fa-minus' style='color:red;'></i>
                                                </a>
                                            </td>
                                        </tr>";
                                }

                                echo "</tbody></table>";
                            } else {
                                echo "<p>No hay proveedores registrados.</p>";
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Agrega el script de DataTables -->
    <script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.html5.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.dataTables.min.css">
    <!-- <script>
        $(document).ready(function () {
            // Inicializar el DataTable y personalizar la disposición de los elementos
            $('#tablaProveedores').DataTable({
                dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                    "<'row'<'col-md-12'tr>>" +
                    "<'row'<'col-md-6'i><'col-md-6'p>>",
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
                },
                buttons: [
                    {
                        extend: 'excelHtml5',
                        text: 'Exportar a Excel',
                        exportOptions: {
                            columns: ':visible'
                        }
                    },
                    {
                        text: 'Agregar Nuevo Proveedor',
                        attr: {
                            id: 'btnAgregar',
                            class: 'btn btn-primary'
                        },
                        action: function () {
                            window.location.href = 'registro_proveedor.php'
                        }
                    }
                ],
                columnDefs: [
                    {
                        targets: -1,
                        width: '100px', // Ajusta el ancho de la columna de acciones
                        className: 'dt-head-center dt-body-center'
                    }
                ],
                responsive: true
            });
            
            // Agregar evento para editar proveedor
            $('#tablaProveedores').on('click', '.btn-editar', function () {
                // Obtiene la fila que contiene los datos del proveedor
                $tr = $(this).closest('tr');

                // Obtiene el ID del proveedor
                var idProveedor = $tr.find("td:eq(0)").text();

                // Redirecciona a la página de edición de proveedor
                window.location.href = 'editar_proveedor.php?id=' + idProveedor;
            });

            // Agregar evento para eliminar proveedor
            $('#tablaProveedores').on('click', '.btn-borrar', function () {
                // Obtiene la fila que contiene los datos del proveedor
                $tr = $(this).closest('tr');

                // Obtiene el ID del proveedor
                var idProveedor = $tr.find("td:eq(0)").text();
                var nombreProveedor = $tr.find("td:eq(1)").text();

                // Muestra un mensaje de confirmación para eliminar el proveedor
                var eliminar = confirm("¿Estás seguro de eliminar el proveedor: " + nombreProveedor + "?");

                // Si el usuario confirma la eliminación, realiza la eliminación a través de AJAX
                if (eliminar) {
                    $.ajax({
                        type: 'POST',
                        url: '../assets/includes/eliminar_proveedor.php',
                        data: { idProveedor: idProveedor },
                        
                        success: function (response) {
                            if (response.success) {
                                // Si la eliminación fue exitosa, recarga la tabla de proveedores
                                alert('Proveedor eliminado exitosamente.');
                                location.reload();
                            } else {
                                // Si hubo un error en la eliminación, muestra un mensaje de error
                                alert('Error al eliminar el proveedor: ' + response.message);
                            }
                        },
                        error: function () {
                            // Si hay un error en la solicitud AJAX, muestra un mensaje de error
                            alert('Error en la solicitud AJAX para eliminar el proveedor.');
                        }
                    });
                }
            });
        });
    </script> -->

    <script>
    $(document).ready(function () {
        // Inicializar el DataTable y personalizar la disposición de los elementos
        $('#tablaProveedores').DataTable({
            dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                "<'row'<'col-md-12'tr>>" +
                "<'row'<'col-md-6'i><'col-md-6'p>>",
            language: {
                url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
            },
            buttons: [
                {
                    extend: 'excelHtml5',
                    text: 'Exportar a Excel',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    text: 'Agregar Nuevo Proveedor',
                    attr: {
                        id: 'btnAgregar',
                        class: 'btn btn-primary'
                    },
                    action: function () {
                        window.location.href = 'registro_proveedor.php'
                    }
                }
            ],
            columnDefs: [
                {
                    targets: -1,
                    width: '100px', // Ajusta el ancho de la columna de acciones
                    className: 'dt-head-center dt-body-center'
                }
            ],
            responsive: true
        });

        // Agregar evento para editar proveedor
        $('#tablaProveedores').on('click', '.btn-editar', function () {
            // Obtiene la fila que contiene los datos del proveedor
            $tr = $(this).closest('tr');

            // Obtiene el ID del proveedor
            var idProveedor = $tr.find("td:eq(0)").text();

            // Redirecciona a la página de edición de proveedor
            window.location.href = 'editar_proveedor.php?id=' + idProveedor;
        });

        // Agregar evento para eliminar proveedor
        $('#tablaProveedores').on('click', '.btn-borrar', function () {
            // Obtiene la fila que contiene los datos del proveedor
            $tr = $(this).closest('tr');

            // Obtiene el ID del proveedor
            var idProveedor = $tr.find("td:eq(0)").text();
            var nombreProveedor = $tr.find("td:eq(1)").text();

            // Muestra un mensaje de confirmación para eliminar el proveedor
            var eliminar = confirm("¿Estás seguro de eliminar el proveedor: " + nombreProveedor + "?");

            // Si el usuario confirma la eliminación, realiza la eliminación a través de AJAX
            if (eliminar) {
                $.ajax({
                    type: 'POST',
                    url: '../assets/includes/eliminar_proveedor.php',
                    data: { idProveedor: idProveedor },

                    success: function (response) {
                        if (response.success) {
                            // Si la eliminación fue exitosa, recarga la tabla de proveedores
                            alert('Proveedor eliminado exitosamente.');
                            location.reload();
                        } else {
                            // Si hubo un error en la eliminación, muestra un mensaje de error
                            alert('Error al eliminar el proveedor: ' + response.message);
                        }
                    },
                    error: function () {
                        // Si hay un error en la solicitud AJAX, muestra un mensaje de error
                        alert('Error en la solicitud AJAX para eliminar el proveedor.');
                    }
                });
            }
        });
    });
</script>


</body>
</html>
