<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Incluir el archivo de conexión
include '../assets/includes/conexion.php';

// Verificar si se recibieron los datos esperados
if (
    isset($_POST['idFactura']) &&
    isset($_POST['observacion']) &&
    isset($_POST['importeTotal']) &&
    isset($_POST['iva10']) &&
    isset($_POST['iva5']) &&
    isset($_POST['excenta']) &&
    isset($_POST['idCuentaContable'])
) {
    // Obtener los datos del formulario
    $idFactura = $_POST['idFactura'];
    $observacion = $_POST['observacion'];
    $importeTotal = $_POST['importeTotal'];
    $iva10 = $_POST['iva10'];
    $iva5 = $_POST['iva5'];
    $excenta = $_POST['excenta'];
    $idCuentaContable = $_POST['idCuentaContable'];

    // Crear una instancia de la clase de conexión
    $conexionDB = new ConexionDB();
    $conn = $conexionDB->conectar();

    // Preparar la consulta SQL para insertar en la tabla detalle_factura
    $sql = "INSERT INTO detalle_factura (id_factura, observacion, importe_total, iva_10, iva_5, excenta, id_cuenta_contable) VALUES (?, ?, ?, ?, ?, ?, ?)";

    // Preparar la sentencia
    $stmt = $conn->prepare($sql);

    // Vincular los parámetros
    $stmt->bind_param("isddddd", $idFactura, $observacion, $importeTotal, $iva10, $iva5, $excenta, $idCuentaContable);

    // Ejecutar la sentencia
    if ($stmt->execute()) {
        // Devolver una respuesta exitosa (puedes personalizar según tus necesidades)
        echo "Detalle de factura guardado correctamente.";
    } else {
        // Manejar el error si la ejecución de la sentencia falla
        echo "Error al insertar el detalle de factura: " . $stmt->error;
    }

    // Cerrar la conexión y liberar recursos
    $stmt->close();
    $conn->close();
} else {
    // Si no se recibieron los datos esperados, devolver un mensaje de error
    echo "Error: Datos incompletos o incorrectos.";
}
?>
