<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();



// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Función para obtener los datos del paciente
function obtenerDatosPaciente($idCliente)
{
    global $conn;

    $sql = "SELECT c.id_cliente, c.nombre, c.apellido, c.cedula, c.contacto_telefono, c.resumen_administrativo,
                   cc.nombre_categoria, sm.cobertura_medica, sm.id_cliente, sm.id_proveedor, sm.fecha_inicio, sm.fecha_fin,
                   p.nombre_empresa AS nombre_proveedor
            FROM clientes c
            LEFT JOIN categoria_cliente cc ON c.id_categoria = cc.id_categoria
            LEFT JOIN seguro_medico sm ON c.id_cliente = sm.id_cliente
            LEFT JOIN proveedores p ON sm.id_proveedor = p.id_proveedor
            WHERE c.id_cliente = ?";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idCliente);
    $stmt->execute();
    $result = $stmt->get_result();
    $datosPaciente = $result->fetch_assoc();
    $stmt->close();

    return $datosPaciente;
}

// Obtener el ID del paciente desde la URL o de otra manera
$idPaciente = $_GET['id']; // Ajusta según cómo obtienes el ID del paciente

// Obtener datos del paciente
$datosPaciente = obtenerDatosPaciente($idPaciente);

// Procesar formulario de registro de consulta
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["nuevaConsulta"])) {
    // Obtén los datos del formulario
    $idUsuario = $_POST["idUsuario"];
    $fecha = $_POST["fecha"];
    $textoMotivo = $_POST["textoMotivo"];
    $textoHistorial = $_POST["textoHistorial"];
    $indicaciones = $_POST["indicaciones"];
    $proxConsulta = $_POST["proxConsulta"];


    // Inserta la nueva consulta en la base de datos
    $stmt = $conn->prepare("INSERT INTO historial_medico (id_cliente, id_medico, fecha, motivo_consulta, texto_historial, indicaciones_medicas, proxima_consulta) VALUES (?, ?, ?, ?, ?, ?, ?)");

    if ($stmt === false) {
        die('Error de preparación de la consulta: ' . $conn->error);
    }

    $stmt->bind_param("iisssss", $idPaciente, $idUsuario, $fecha, $textoMotivo, $textoHistorial, $indicaciones, $proxConsulta);
    $exitoInsercion = $stmt->execute();

    if ($exitoInsercion) {
        // Redirige a la página de ficha paciente con un mensaje de éxito en alert
        $mensaje = "Consulta registrada exitosamente";
    } else {
        // Redirige a la página de ficha paciente con un mensaje de error
        $error = "Error al registrar la consulta";
    }
    $stmt->close();
}

// Procesar formulario de registro de orden de estudio
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST["nuevaOrden"])) {
    // Obtén los datos del formulario
    $idUsuario = $_POST["idUsuarioOrden"];
    $fecha = $_POST["fechaOrden"];
    $observacion = $_POST["textoObservacionOrden"];
    
    // Inserta la nueva orden de estudio en la base de datos
    $stmt = $conn->prepare("INSERT INTO ordenes_estudios (id_cliente, id_usuario, fecha, observacion) VALUES (?, ?, ?, ?)");

    if ($stmt === false) {
        die('Error de preparación de la consulta: ' . $conn->error);
    }

    $stmt->bind_param("iiss", $idPaciente, $idUsuario, $fecha, $observacion);
    $exitoInsercion = $stmt->execute();

    if ($exitoInsercion) {
        // Obten el ID de la orden recién insertada
        $idOrdenEstudio = $stmt->insert_id;

        // Obtén los estudios seleccionados
        $estudiosSeleccionados = isset($_POST["estudioOrden"]) ? $_POST["estudioOrden"] : array();

        // Inserta los estudios seleccionados en la tabla de relación
        foreach ($estudiosSeleccionados as $idEstudio) {
            $stmtRelacion = $conn->prepare("INSERT INTO ordenes_estudios_estudios (id_orden_estudio, id_estudio) VALUES (?, ?)");
            $stmtRelacion->bind_param("ii", $idOrdenEstudio, $idEstudio);
            $stmtRelacion->execute();
            $stmtRelacion->close();
        }

        // Redirige a la página de ficha paciente con un mensaje de éxito en alert
        $mensajeOrden = "Orden de estudio registrada exitosamente";
    } else {
        // Redirige a la página de ficha paciente con un mensaje de error
        $error = "Error al registrar la orden de estudio";
    }

    $stmt->close();
}


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Ficha Pacientes</title>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" integrity="sha384-dTveEnQIJCpMSIP3C4PSLdJveBU8lqF1ehmhtZ3Iu2vU9kQpZzlhPmWQihJfVw49" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>

    <?php include '../assets/includes/navegacion.php'; ?>

    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Ficha del Paciente</h2>
                        </div>
                        <div class="card-body">

                            <!-- Mostrar datos del paciente -->
                            <div class="container">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-4">
                                            <h3 style="color: #4664B5;">Datos del Paciente</h3>
                                            
                                            <hr width="100%" style="color: #999999;"/>
                                            <b><p><strong>Código de Paciente:</strong></b> <?php echo $datosPaciente['id_cliente']; ?></p>
                                            <b><p><strong>Nombre:</strong></b> <?php echo $datosPaciente['nombre']; ?></p>
                                            <b><p><strong>Apellido:</strong></b> <?php echo $datosPaciente['apellido']; ?></p>
                                            <b><p><strong>Cédula:</strong></b> <?php echo $datosPaciente['cedula']; ?></p>
                                            <b><p><strong>Teléfono de Contacto:</strong></b> <?php echo $datosPaciente['contacto_telefono']; ?></p>
                                            <b><p><strong>Observación Administrativa:</strong></b> <?php echo $datosPaciente['resumen_administrativo']; ?></p>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-4">
                                            <!-- Datos del seguro -->
                                            <h3 style="color: #4664B5;">Datos del Seguro Médico</h3>
                                            <hr width="100%" style="color: #999999;"/>
                                            <b><p><strong>Categoría:</strong> <?php echo $datosPaciente['nombre_categoria']; ?></p>
                                            <p><strong>Cobertura Médica:</strong> <?php echo $datosPaciente['cobertura_medica']; ?></p>
                                            <p><strong>Seguro Médico:</strong> <?php echo $datosPaciente['nombre_proveedor']; ?></p>
                                            <p><strong>Vigencia Desde:</strong>
                                            <?php if ($datosPaciente['fecha_inicio'] !== null) {
                                                echo date("d-m-Y", strtotime($datosPaciente['fecha_inicio']));
                                            } else {
                                                echo $datosPaciente['fecha_inicio'];
                                            }
                                            ?></p>

                                            <p><strong>Vigencia Hasta:</strong>
                                            <?php if ($datosPaciente['fecha_fin'] !== null) {
                                                echo date("d-m-Y", strtotime($datosPaciente['fecha_fin']));
                                            } else {
                                                echo $datosPaciente['fecha_fin'];
                                            }
                                            ?></p>

                                        </div>
                                    </div>
                                </div>
                                <hr width="100%" style="color: #999999;"/>
                            </div>

                            <!-- Botones para acceder a diferentes secciones -->
                            <div class="mb-4">
                                <a href="#" class="btn btn-primary btn-citas">
                                    <i class="fas fa-notes-medical"></i> | Registrar Consulta
                                </a>

                                <a href="#" class="btn btn-primary btn-historial-citas">
                                    <i class="fas fa-book-medical"></i> | Historial de Consultas
                                </a>
                                

                                <a href="#" class="btn btn-primary btn-ordenes">
                                    <i class="fas fa-file-prescription"></i> | Orden de Estudios
                                </a>

                                <a href="#" class="btn btn-primary btn-cargar_resultados">
                                    <i class="fas fa-file-waveform"></i> | Cargar Resultados
                                </a>

                                
                                <a href="#" class="btn btn-primary btn-resultados">
                                    <i class="fas fa-file-waveform"></i> | Resultados de Estudios
                                </a>

                                
                            </div>

                            <!-- Sección de Citas -->
                            <div class="seccion-citas mb-4">
                                <hr width="100%" style="color: #999999;"/>
                                <h4 class="mb-4">Nueva Consulta</h4>
                                <div class="d-flex justify-content-between">
                                    <div class="card-body">
                                        <form action="" method="post">
                                            <!-- Selector de médicos con Select2 -->
                                            <div class="mb-3">
                                            <label for="buscar-medico">Médico</label>
                                                <br>
                                                <select id="buscar-medico" class="btn btn-outline btn-lg" required>
                                                    <option value="" selected disabled>Buscar Médico por Nombre o RUC</option>
                                                </select>
                                                <!-- Agrega un campo oculto para almacenar el idUsuario -->
                                                <input type="hidden" id="idUsuario" name="idUsuario">
                                            </div>
                                        

                                            <div class="mb-3">
                                                <label for="fecha">Fecha</label>
                                                <!-- Puedes usar un selector de fecha o un campo de entrada manual -->
                                                <input type="date" class="form-control" id="fecha" name="fecha" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="textoMotivo">Motivo de la Consulta</label>
                                                <textarea class="form-control" id="textoMotivo" name="textoMotivo" placeholder="Introduce el motivo de la consulta" required></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label for="textoHistorial">Informe del Médico</label>
                                                <textarea class="form-control" id="textoHistorial" name="textoHistorial" placeholder="Introduce el informe médico" required></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label for="indicaciones">Indicaciones para el Paciente</label>
                                                <textarea class="form-control" id="indicaciones" name="indicaciones" placeholder="Introduce las indicaciones para el paciente"></textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label for="proxConsulta">Proxima Consulta</label>
                                                <!-- Puedes usar un selector de fecha o un campo de entrada manual -->
                                                <input type="date" class="form-control" id="proxConsulta" name="proxConsulta">
                                            </div>
                                            <div class="d-flex justify-content-between">
                                                <button type="submit" name="nuevaConsulta" class="btn btn-primary">Guardar Registro</button>
                                            </div>

                                            <!-- Agrega un mensaje de éxito o error según sea el caso -->
                                            <?php if (isset($mensaje)) : ?>
                                                
                                                    <?php echo "<script>alert('$mensaje');</script>"; ?>
                                                
                                            <?php endif; ?>
                                            <?php if (isset($error)) : ?>
                                                
                                                <?php echo "<script>alert('$mensaje');</script>"; ?>
                                                
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <!-- Sección de Historial de Citas -->
                            <div class="seccion-historial-citas mb-4">
                                <hr width="100%" style="color: #999999;"/>
                                <h4 class="mb-4">Historial de Consultas</h4>
                                <div class="card-body table-responsive">
                                    <table id="tablaConsultasMedicasPaciente" class="table table-striped table-bordered" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th hidden>ID</th>
                                                <th>Paciente</th>
                                                <th>Médico</th>
                                                <th>Motivo de Consulta</th>
                                                <th>Informe Médico</th>
                                                <th>Fecha</th>
                                                <th>Ver Consulta</th>
                                                <th>Eliminar</th>

                                                
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Aquí se insertarán las filas de la tabla -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <!-- Sección de Estudios -->
                            <div class="seccion-nueva-orden mb-4">
                            
                            <hr width="100%" style="color: #999999;"/>
                            <h4 class="mb-4">Nueva Orden de Estudio</h4>
                                <div class="d-flex justify-content-between">
                                    <div class="card-body">
                                        <form id="formularioNuevaOrden" action="" method="post">
                                            <div class="mb-3">
                                            <label for="medicoOrden">Médico</label>
                                                <br>
                                                <select id="medicoOrden" class="btn btn-outline btn-lg" required>
                                                    <option value="" selected disabled>Buscar Médico por Nombre o RUC</option>
                                                </select>
                                                <!-- Agrega un campo oculto para almacenar el idUsuario -->
                                                <input type="hidden" id="idUsuarioOrden" name="idUsuarioOrden">
                                            </div>
                        
                                            <div class="mb-3">
                                                <label for="fechaOrden">Fecha</label>
                                                <!-- Puedes usar un selector de fecha o un campo de entrada manual -->
                                                <input type="date" class="form-control" id="fechaOrden" name="fechaOrden" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="categoriaEstudio">Categoría de Estudio</label>
                                                <select class="form-select" id="categoriaEstudio" name="categoriaEstudio" required>
                                                    <option selected>Selecciona una Categoría</option>
                                                    <?php
                                                    $sqlCategorias = "SELECT * FROM categoria_estudios";
                                                    $resultCategorias = ejecutarConsulta($sqlCategorias);
                                                    while ($rowCategoria = $resultCategorias->fetch_assoc()) {
                                                        echo '<option value="'.$rowCategoria['id_categoria_estudios'].'">'.$rowCategoria['nombre_categoria_estudio'].'</option>';
                                                    }
                                                    ?>
                                                </select>
                                            </div>

                                            <div class="mb-3">
                                                <label for="estudioOrden">Estudios</label>
                                                <select class="form-select" id="estudioOrden" name="estudioOrden[]" multiple required>
                                                    <!-- Aquí se cargarán los estudios mediante AJAX después de seleccionar la categoría -->
                                                </select>
                                            </div>
                                            <div class="mb-3">
                                                <label for="textoObservacionOrden">Observación</label>
                                                <textarea class="form-control" id="textoObservacionOrden" name="textoObservacionOrden" placeholder="Introduce alguna Observación"></textarea>
                                            </div>
                                            
                                            <div class="d-flex justify-content-between">
                                                <button type="submit" id="bntCrearOrden" name="nuevaOrden" class="btn btn-primary">Guardar Registro</button>
                                            </div>

                                            <!-- Agrega un mensaje de éxito o error según sea el caso -->
                                            <?php if (isset($mensajeOrden)) : ?>
                                                
                                                    <?php echo "<script>alert('$mensajeOrden');</script>"; ?>
                                                
                                            <?php endif; ?>
                                            <?php if (isset($error)) : ?>
                                                
                                                <?php echo "<script>alert('$mensajeOrden');</script>"; ?>
                                                
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                </div>
                            </div>    
                            
                            <div class="seccion-ordenes mb-4">
                                <hr width="100%" style="color: #999999;"/>
                                <h4 class="mb-4">Historial de Órdenes de Estudios</h4>
                                <button type="button" class="btn btn-primary btn-nueva-orden">
                                    <i class="fas fa-file-prescription"></i> | Nueva Orden de Estudio
                                </button>
                                <div class="card-body table-responsive">
                                    <table id="tablaOrdenesEstudio" class="table table-striped table-bordered" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th >Orden N°</th>
                                                <th>Fecha</th>
                                                <th>Paciente</th>
                                                <th>Médico</th>
                                                <th>Estudio Realizado</th>
                                                <th hidden>Observación</th>
                                                <th>Ver Orden</th>
                                                
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Aquí se insertarán las filas de la tabla -->
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                            <div class="seccion-resultados mb-4">
                                <hr width="100%" style="color: #999999;" />
                                <h4 class="mb-4">Resultados de Estudios</h4>
                                <div class="card">
                                    <div class="card-body">
                                        <!-- Formulario para buscar resultados de orden de estudio -->
                                        <form action="#" method="post" id="formBuscarResultados">
                                            <div class="mb-3">
                                                <label for="numeroOrden">Número de Orden de Estudio:</label>
                                                <input type="text" class="form-control" id="numeroOrden" name="numero_orden" placeholder="Introduce el número de orden" required>
                                            </div>
                                            <div class="d-flex justify-content-between">
                                                <button type="submit" class="btn btn-primary">Buscar Resultados</button>
                                            </div>
                                        </form>

                                        <!-- Aquí se mostrará la información de resultados después de enviar el formulario -->
                                        <div id="resultadosInfo"></div>

                                    </div>
                                </div>
                            </div>

                            <div class="seccion-cargar-resultados mb-4">
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>


    <!-- Scripts al final para mejorar la carga de la página -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2Xof8+cu6Qr5I5Ih0k5r4aFslw8Z5Gz0D93Q" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/js/select2.min.js"></script>

    
    <script>
        $(document).ready(function () {
            // Oculta todas las secciones al principio
            $('.seccion-citas, .seccion-historial-citas, .seccion-historial-medico, .seccion-ordenes, .seccion-resultados, .seccion-nueva-orden, .seccion-cargar-resultados',).hide();

            // Maneja el envío del formulario para buscar resultados
            $('#formBuscarResultados').submit(function (e) {
                e.preventDefault();

                var numeroOrden = $('#numeroOrden').val();

                // Realiza la solicitud AJAX para obtener los resultados
                $.ajax({
                    url: 'obtener_resultados.php', // Reemplaza con la ruta correcta
                    type: 'POST',
                    data: { numeroOrden: numeroOrden },
                    dataType: 'json',
                    success: function (data) {
                        // Construye y muestra la información de resultados
                        var resultadosInfo = '';
                        
                        if (data.resultadosCargados > 0) {

                            resultadosInfo += '<table class="table">';
                            resultadosInfo += '<thead><tr><th>Nombre de Archivo</th><th>Tipo de Archivo</th><th>Acciones</th></tr></thead>';
                            resultadosInfo += '<tbody>';

                            $.each(data.archivosCargados, function (index, archivo) {

                                resultadosInfo += '<td>' + archivo.nombre_archivo + '</td>';
                                resultadosInfo += '<td>' + archivo.tipo_archivo + '</td>';
                                resultadosInfo += '<td><a href="ver_resultado.php?id_orden=' + archivo.id_orden_estudio + '&nombre_archivo=' + archivo.nombre_archivo + '" target="_blank" class="btn btn-info btn-sm">Ver Detalles</a></td>';
                                resultadosInfo += '</tr>';
                            });

                            resultadosInfo += '</tbody></table>';
                        } else {
                            resultadosInfo += '<p>No hay archivos cargados para esta orden de estudio.</p>';
                        }

                        // Mostrar el formulario solo si hay archivos permitidos
                        if (data.archivosPermitidos > 0) {
                            $('#formCargarResultados').removeClass('d-none');
                        }


                        // Muestra la información en el contenedor resultadosInfo
                        $('#resultadosInfo').html(resultadosInfo);

                        // Actualiza el mensaje en el formulario de carga de resultados
                        $('#resultados').attr('placeholder', 'Cargar hasta 10 archivos (puedes cargar ' + data.archivosPermitidos + ' archivos más)');

                    },
                    error: function (error) {
                        console.log(error);
                    }
                });
            });


            // Maneja el clic en el botón de Citas
            $('.btn-citas').click(function (e) {
                e.preventDefault();
                // Oculta todas las secciones y muestra solo la de Citas
                $('.seccion-citas, .seccion-historial-citas, .seccion-historial-medico, .seccion-tratamientos-en-curso, .seccion-ordenes, .seccion-resultados, .seccion-nueva-orden, .seccion-cargar-resultados').hide();
                $('.seccion-citas').show();
            });

            // Maneja el clic en el botón resultadoss
            $('.btn-resultados').click(function (e) {
                e.preventDefault();
                // Oculta todas las secciones y muestra solo la de Resultados
                $('.seccion-citas, .seccion-historial-citas, .seccion-historial-medico, .seccion-tratamientos-en-curso, .seccion-ordenes, .seccion-resultados, .seccion-nueva-orden, .seccion-cargar-resultados').hide();
                $('.seccion-resultados').show();
            });

            // Maneja el clic en el botón de Historial de Citas
            $('.btn-historial-citas').click(function (e) {
                e.preventDefault();
                // Oculta todas las secciones y muestra solo la de Historial de Citas
                $('.seccion-citas, .seccion-historial-citas, .seccion-historial-medico, .seccion-tratamientos-en-curso, .seccion-ordenes, .seccion-resultados, .seccion-nueva-orden, .seccion-cargar-resultados').hide();
                $('.seccion-historial-citas').show();

                //reiniciar el datatable
                $('#tablaConsultasMedicasPaciente').DataTable().destroy();

                // Realiza una solicitud AJAX para obtener los datos del historial de citas del paciente seleccionado
                $.ajax({
                    url: 'historial_consultas.php',
                    type: 'POST',
                    data: { idPaciente: <?php echo $idPaciente; ?> },
                    dataType: 'json', // Especifica que la respuesta será en formato JSON
                    success: function (data) {
                        // Construye dinámicamente las filas de la tabla con los datos JSON
                        var tableRows = '';
                        $.each(data, function (index, row) {
                                // Dividimos la fecha en partes
                                const fechaPartes = row.fecha.split('-');
                                
                                // Unimos las partes en el formato deseado
                                const fechaFormateada = fechaPartes[2] + '-' + fechaPartes[1] + '-' + fechaPartes[0]; 
                                tableRows += '<tr>' +
                                '<td hidden>' + row.id_historial + '</td>' +
                                '<td>' + row.nombre + ' ' + row.apellido + '</td>' +
                                '<td>' + row.nombre_medico + ' ' + row.apellido_medico + '</td>' +
                                '<td>' + row.motivo_consulta + '</td>' +
                                '<td>' + row.texto_historial + '</td>' +
                                '<td>' + fechaFormateada + '</td>' +
                                '<td>' +
                                '<a href="#" class="btn-informe_consulta" data-id="' + row.id_historial + '" title="Ver Informe">' +
                                '<i class="fa fa-receipt"></i>' +
                                '</a>' +
                                '</td>' +
                                '<td>' +
                                '<a href="#" class="btn-eliminar_consulta" data-id="' + row.id_historial + '" title="Eliminar Consulta">' +
                                '<i class="fa fa-trash"></i>' +
                                '</a>' +
                                '</tr>';
                            
                            
                        });

                        // Inserta las filas en la tabla de consultas médicas en la sección de Historial de Citas
                        $('#tablaConsultasMedicasPaciente tbody').html(tableRows);

                        // Inicializa DataTables
                        $('#tablaConsultasMedicasPaciente').DataTable({
                            // Configuración del DataTable
                            dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                                "<'row'<'col-md-12'tr>>" +
                                "<'row'<'col-md-6'i><'col-md-6'p>>",
                            language: {
                                url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
                            },
                            searching: true, // Habilita la búsqueda
                        });
                    },
                    error: function (error) {
                        console.log(error);
                    }
                });
            });

            // Maneja el clic en el botón ordenes
            $('.btn-ordenes').click(function (e) {
                e.preventDefault();
                // Oculta todas las secciones y muestra solo la de ordenes
                $('.seccion-citas, .seccion-historial-citas, .seccion-historial-medico, .seccion-tratamientos-en-curso, .seccion-ordenes, .seccion-resultados, .seccion-nueva-orden, .seccion-cargar-resultados').hide();
                $('.seccion-ordenes').show();
            });

            //reiniciar datatable ordenes
            $('#tablaOrdenesEstudio').DataTable().destroy();

            // Realiza una solicitud AJAX para obtener los datos de las ordenes de estudio del paciente seleccionado
            $.ajax({
                url: 'buscar_ordenes_estudio.php',
                type: 'POST',
                data: { idPaciente: <?php echo $idPaciente; ?> },
                dataType: 'json',
                success: function (data) {
                    console.log("Datos recibidos:", data);

                    var tableRows = '';
                    $.each(data, function (index, row) {
                        console.log("Procesando fila:", row);

                        const fechaPartes = row.fecha.split('-');
                        const fechaFormateada = fechaPartes[2] + '-' + fechaPartes[1] + '-' + fechaPartes[0];

                        // Ahora procesa los múltiples estudios asociados con cada orden
                        var estudios = '';
                        $.each(row.estudios, function (i, estudio) {
                            console.log("Estudio:", estudio);
                            estudios += '- ' + estudio + '<br>';  // Accede a 'estudio' directamente
                        });

                        tableRows += '<tr>' +
                            '<td>' + row.id_orden_estudio + '</td>' +
                            '<td>' + fechaFormateada + '</td>' +
                            '<td>' + row.nombre + ' ' + row.apellido + '</td>' +
                            '<td>' + row.nombre_medico + ' ' + row.apellido_medico + '</td>' +
                            '<td>' + estudios + '</td>' +
                            '<td hidden>' + row.observacion + '</td>' +
                            '<td>' +
                            '<a href="#" class="btn-informe_orden" data-id="' + row.id_orden_estudio + '" title="Ver Informe">' +
                            '<i class="fa fa-receipt"></i>' +
                            '</a>' +                  
                            '<a href="#" class="btn-resultado_orden" data-id="' + row.id_orden_estudio + '" title="Ver Resultado">' +
                            '<i class="fa fa-file-waveform"></i>' +
                            '</a>' +
                            '<a href="#" class="btn-eliminar_orden" data-id="' + row.id_orden_estudio + '" title="Eliminar Orden">' +
                                '<i class="fa fa-trash"></i>' +
                                '</a>' +
                            '</td>' +
                            '</tr>';
                    });

                    $('#tablaOrdenesEstudio tbody').html(tableRows);

                    // Inicializa DataTables
                    $('#tablaOrdenesEstudio').DataTable({
                        dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                            "<'row'<'col-md-12'tr>>" +
                            "<'row'<'col-md-6'i><'col-md-6'p>>",
                        language: {
                            url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                        },
                        searching: true,
                    });
                },
                error: function (error) {
                    console.log("Error en la solicitud AJAX:", error);
                }
            });


                // Maneja el clic en el botón de Nueva Orden
                $('.btn-nueva-orden').click(function (e) {
                    e.preventDefault();
                    // Oculta todas las secciones y muestra solo la de Nueva Orden
                    $('.seccion-citas, .seccion-historial-citas, .seccion-historial-medico, .seccion-tratamientos-en-curso, .seccion-ordenes, .seccion-resultados, .seccion-nueva-orden, .seccion-cargar-resultados').hide();
                    $('.seccion-nueva-orden').show();
                });


                // Maneja el clic en el botón de Nueva Orden
                $('.btn-cargar_resultados').click(function (e) {
                    e.preventDefault();
                    // Oculta todas las secciones y muestra solo la de Nueva Orden
                    $('.seccion-citas, .seccion-historial-citas, .seccion-historial-medico, .seccion-tratamientos-en-curso, .seccion-ordenes, .seccion-resultados, .seccion-nueva-orden, .seccion-cargar-resultados').hide();
                    window.location.href = 'cargar_resultados.php';
                });

                $(document).on('click', '.btn-eliminar_consulta', function (e) {
                    e.preventDefault();
                    var idHistorial = $(this).data('id');

                    // Realiza la solicitud AJAX para eliminar la consulta
                    $.ajax({
                        url: 'eliminar_consulta.php',
                        type: 'POST',
                        data: { idHistorial: idHistorial },
                        dataType: 'json',
                        success: function (data) {
                            // Muestra un mensaje de éxito o error solo si la eliminación fue exitosa
                            if (data.success) {
                                alert('Consulta eliminada correctamente');
                                $('.btn-historial-citas').click();
                            } else {
                                alert('Error al eliminar la consulta: ' + data.message);
                            }
                        },
                        error: function (error) {
                            console.log(error);
                        }
                    });
                });

                $(document).on('click', '.btn-eliminar_orden', function (e) {
                    e.preventDefault();
                    var id_orden_estudio = $(this).data('id');

                    // Realiza la solicitud AJAX para eliminar la consulta
                    $.ajax({
                        url: 'eliminar_orden.php',
                        type: 'POST',
                        data: { id_orden_estudio: id_orden_estudio },
                        dataType: 'json',
                        success: function (data) {
                            // Muestra un mensaje de éxito o error solo si la eliminación fue exitosa
                            if (data.success) {
                                alert('Orden eliminada correctamente');
                                //recargar pagina completa
                                location.reload();
                            } else {
                                alert('Error al eliminar la orden: ' + data.message);
                            }
                        },
                        error: function (error) {
                            console.log(error);
                        }
                    });
                });



                // Configuración de Select2 para el selector de médicos
                $('#buscar-medico').select2({
                    ajax: {
                        type: 'POST',
                        url: 'buscar_medico.php',
                        delay: 250,
                        data: function (params) {
                            return {
                                filtroMedico: params.term,
                            };
                        },
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (item) {
                                    return {
                                        text: item.nombre + ' ' + item.apellido,
                                        id: item.id_usuario,
                                        
                                    };
                                }),
                            };
                        },
                        cache: true,
                    },
                    placeholder: 'Buscar Médico por Nombre o RUC',
                    minimumInputLength: 2,
                });

                // Agrega un evento change para capturar la selección
                $('#buscar-medico').on('change', function (e) {
                    // Obtén el id_usuario seleccionado
                    var idUsuarioSeleccionado = $(this).val();
                    
                    // Asigna el idUsuario al campo oculto
                    $('#idUsuario').val(idUsuarioSeleccionado);
                });
                // campo de medicos orden
               // Configura el evento de entrada en el campo de búsqueda de medicos orden
               $('#medicoOrden').select2({
                    ajax: {
                        type: 'POST',
                        url: 'buscar_medico_orden.php',
                        delay: 250,
                        data: function (params) {
                            return {
                                filtroMedicoOrden: params.term,
                            };
                        },
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (item) {
                                    return {
                                        text: item.nombreOrden + ' ' + item.apellidoOrden,
                                        id: item.id_usuarioOrden,
                                        
                                    };
                                }),
                            };
                        },
                        cache: true,
                    },
                    placeholder: 'Buscar Médico por Nombre o RUC',
                    minimumInputLength: 2,
                });

                // Agrega un evento change para capturar la selección
                $('#medicoOrden').on('change', function (e) {
                    // Obtén el id_usuario seleccionado
                    var idUsuarioSeleccionadoOrden = $(this).val();
                    console.log(idUsuarioSeleccionadoOrden);
                    
                    // Asigna el idUsuario al campo oculto
                    $('#idUsuarioOrden').val(idUsuarioSeleccionadoOrden);
                    console.log(idUsuarioSeleccionadoOrden);
                });

                // Configura el evento de cambio en la categoría de estudio
                $('#categoriaEstudio').change(function () {
                    var idCategoria = $(this).val();

                    // Realiza la solicitud AJAX para cargar estudios basados en la categoría seleccionada
                    $.ajax({
                        type: 'POST',
                        url: 'cargar_estudios.php', // Debes crear este archivo PHP para manejar la carga de estudios
                        data: { idCategoria: idCategoria },
                        dataType: 'json',
                        success: function (data) {
                            // Limpia y carga los nuevos estudios en el campo select
                            $('#estudioOrden').empty();
                            $.each(data, function (index, estudio) {
                                $('#estudioOrden').append('<option value="' + estudio.id_estudio + '">' + estudio.nombre_estudio + '</option>');
                            });

                            // Inicializa Select2 para permitir la selección múltiple
                            $('#estudioOrden').select2();
                        },
                        error: function (error) {
                            console.log(error);
                        }
                    });
                });
        });

            $(document).on('click', '.btn-informe_consulta', function (e) {
                e.preventDefault();
                var idHistorial = $(this).data('id');

                // abre informe consulta en una nueva pestaña
                window.open('informe_consulta.php?id=' + idHistorial, '_blank');

            });

            $(document).on('click', '.btn-informe_orden', function (e) {
                e.preventDefault();
                var id_orden_estudio = $(this).data('id');

                // abre informe consulta en una nueva pestaña
                window.open('orden_estudio.php?id=' + id_orden_estudio, '_blank');

            });

            $(document).on('click', '.btn-resultado_orden', function (e) {
                // Oculta todas las secciones y muestra solo la de Resultados
                $('.seccion-citas, .seccion-historial-citas, .seccion-historial-medico, .seccion-tratamientos-en-curso, .seccion-ordenes, .seccion-resultados, .seccion-nueva-orden, .seccion-cargar-resultados').hide();
                $('.seccion-resultados').show();
                
                var numeroOrden = $(this).data('id');

                // Realiza la solicitud AJAX para obtener los resultados
                $.ajax({
                    url: 'obtener_resultados.php', // Reemplaza con la ruta correcta
                    type: 'POST',
                    data: { numeroOrden: numeroOrden },
                    dataType: 'json',
                    success: function (data) {
                        // Construye y muestra la información de resultados
                        var resultadosInfo = '';
                        
                        if (data.resultadosCargados > 0) {

                            resultadosInfo += '<table class="table">';
                            resultadosInfo += '<thead><tr><th>Nombre de Archivo</th><th>Tipo de Archivo</th><th>Acciones</th></tr></thead>';
                            resultadosInfo += '<tbody>';

                            $.each(data.archivosCargados, function (index, archivo) {
                                resultadosInfo += '<tr>';
                                resultadosInfo += '<td>' + archivo.nombre_archivo + '</td>';
                                resultadosInfo += '<td>' + archivo.tipo_archivo + '</td>';
                                resultadosInfo += '<td><a href="ver_resultado.php?id_orden=' + archivo.id_orden_estudio + '&nombre_archivo=' + archivo.nombre_archivo + '" target="_blank" class="btn btn-info btn-sm">Ver Detalles</a></td>';
                                resultadosInfo += '<td><button class="btn btn-danger btn-sm btn-eliminar-archivo" data-id="' + archivo.id_resultado + '">Eliminar</button></td>';
                                resultadosInfo += '</tr>';
                            });


                            resultadosInfo += '</tbody></table>';
                        } else {
                            resultadosInfo += '<p>No hay archivos cargados para esta orden de estudio.</p>';
                        }

                        // Muestra la información en el contenedor resultadosInfo
                        $('#resultadosInfo').html(resultadosInfo);
                    },
                    error: function (error) {
                        console.log(error);
                    }
                });

                $(document).on('click', '.btn-eliminar-archivo', function (e) {
                    e.preventDefault();
                    var idArchivo = $(this).data('id');

                    // Realiza la solicitud AJAX para eliminar el archivo
                    $.ajax({
                        url: 'eliminar_archivo.php', // Reemplaza con la ruta correcta
                        type: 'POST',
                        data: { idArchivo: idArchivo },
                        dataType: 'json',
                        success: function (data) {
                            // Recarga la sección de resultados después de eliminar el archivo
                            $('.btn-resultado_orden').click();
                        },
                        error: function (error) {
                            console.log(error);
                        }
                    });
                });


            });

    </script>

</body>
</html>
