<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET["id"])) {
    $idHistorial = $_GET["id"];
    

    // Obtener la información del historial médico
    $sqlHistorial = "SELECT * FROM historial_medico WHERE id_historial = $idHistorial";
    $resultadoHistorial = ejecutarConsulta($sqlHistorial);

    if ($resultadoHistorial->num_rows > 0) {
        $historial = $resultadoHistorial->fetch_assoc();

        // Obtener la información del cliente asociado al historial
        $idCliente = $historial['id_cliente'];
        $sqlCliente = "SELECT nombre, apellido, cedula FROM clientes WHERE id_cliente = $idCliente";
        $resultadoCliente = ejecutarConsulta($sqlCliente);
        

        // Obtener la informacion del usuario asociado al historial
        $idmedico = $historial['id_medico'];
        $sqlMedico = "SELECT nombre, apellido FROM usuarios WHERE id_usuario = $idmedico";
        $resultadoMedico = ejecutarConsulta($sqlMedico);
        

        if ($resultadoCliente->num_rows > 0) {
            $cliente = $resultadoCliente->fetch_assoc();
            
        } else {
            // Manejar la situación si no se encuentra el cliente
            $cliente = array('nombre' => 'N/A', 'apellido' => 'N/A', 'cedula' => 'N/A');
        }

        if ($resultadoMedico->num_rows > 0) {
            $medico = $resultadoMedico->fetch_assoc();
            
        } else {
            // Manejar la situación si no se encuentra el medico
            $medico = array('nombre' => 'N/A', 'apellido' => 'N/A');
        }
    } else {
        // Si no se encuentra el historial médico, redirige a la página de consulta médica
        header("Location: ../../pages/consulta_medica.php");
        exit();
    }
} else {
    // Si no se proporciona un ID válido, redirige a la página de consulta médica
    header("Location: ../../pages/consulta_medica.php");
    exit();
}
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Editar Consultas</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>

    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h2 class="text-center">Editar Consulta Médica</h2>
                        </div>
                        <div class="card-body">
                            <form action="../assets/includes/procesar_editar_consulta.php" method="post">
                                <input type="hidden" name="idConsultaMedica" value="<?php echo $consultaMedica['id_historial']; ?>">
                                <div hidden class="mb-3">
                                    <label for="idHistorial">Fecha</label>
                                    <input type="text" class="form-control" id="idHistorial" name="idHistorial" value="<?php echo $historial['id_historial']; ?>" required readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="fecha">Fecha</label>
                                    <input type="text" class="form-control" id="fecha" name="fecha" value="<?php echo $historial['fecha']; ?>" required readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="paciente">Paciente</label>
                                    <input type="text" class="form-control" id="paciente" name="paciente" value="<?php echo $cliente['nombre'] . ' ' . $cliente['apellido'] . ' (' . $cliente['cedula'] . ')'; ?>" required readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="medico">Medico</label>
                                    <input type="text" class="form-control" id="medico" name="medico" value="<?php echo $medico['nombre'] . ' ' . $medico['apellido'] ; ?>" required readonly>
                                </div>
                                <div class="mb-3">
                                    <label for="textoMotivo">Motivo de Consulta</label>
                                    <textarea class="form-control" id="textoMotivo" name="textoMotivo" rows="5"><?php echo $historial['motivo_consulta']; ?></textarea>
                                </div>                                
                                
                                <div class="mb-3">
                                    <label for="textoConsulta">Diagnostico</label>
                                    <textarea class="form-control" id="textoConsulta" name="textoConsulta" rows="5" required><?php echo $historial['texto_historial']; ?></textarea>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <a href="consulta_medica.php"><button type="button" class="btn btn-secondary">Cancelar</button></a>
                                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include '../assets/includes/navegacion.php'; ?>
<footer class="container">
    <p style="text-align:center;">© Desarrollado por AyP</p>
</footer>

</body>
</html>