<?php
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

if ($_SERVER["REQUEST_METHOD"] == "GET" && isset($_GET["id"])) {
    $idCliente = $_GET["id"];

    // Obtener la información del cliente
    $sql = "SELECT * FROM clientes WHERE id_cliente = $idCliente";
    $resultado = ejecutarConsulta($sql);

    if ($resultado->num_rows > 0) {
        $cliente = $resultado->fetch_assoc();
    } else {
        // Si no se encuentra el cliente, redirige a la página de clientes
        header("Location: ../../pages/clientes.php");
        exit();
    }
} else {
    // Si no se proporciona un ID válido, redirige a la página de clientes
    header("Location: ../../pages/clientes.php");
    exit();
}

// Función para obtener las categorías
function obtenerCategorias()
{
    $sql = "SELECT * FROM categoria_cliente";
    return ejecutarConsulta($sql);
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Editar Paciente</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>

    <!-- Contenido de tu página de edición de cliente -->
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Editar Paciente</h2>
                        </div>
                        <div class="card-body">
                            <form action="../assets/includes/procesar_editar_cliente.php" method="post">
                                <input type="hidden" name="idCliente" value="<?php echo $cliente['id_cliente']; ?>">
                                <div class="mb-3">
                                    <label for="nombre">Nombre</label>
                                    <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo $cliente['nombre']; ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="apellido">Apellido</label>
                                    <input type="text" class="form-control" id="apellido" name="apellido" value="<?php echo $cliente['apellido']; ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="cedula">Cédula</label>
                                    <input type="text" class="form-control" id="cedula" name="cedula" value="<?php echo $cliente['cedula']; ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="fecha_nacimiento">Fecha de Nacimiento</label>
                                    <input type="date" class="form-control" id="fecha_nacimiento" name="fecha_nacimiento" value="<?php echo $cliente['fecha_nacimiento']; ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="categoria">Categoría:</label>
                                    <select class="form-select" id="categoria" name="categoria">
                                        <?php
                                        // Obtener la lista de categorías desde la base de datos
                                        $categorias = obtenerCategorias();

                                        // Verificar si hay categorías
                                        if ($categorias->num_rows > 0) {
                                            while ($categoria = $categorias->fetch_assoc()) {
                                                $selected = ($categoria['id_categoria'] == $datosUsuario['id_categoria']) ? 'selected' : '';
                                                echo "<option value='{$categoria['id_categoria']}' $selected>{$categoria['nombre_categoria']}</option>";
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="mb-3" hidden>
                                    <label for="resumen_administrativo">Resumen Administrativo</label>
                                    <textarea class="form-control" id="resumen_administrativo" name="resumen_administrativo" rows="3"><?php echo $cliente['resumen_administrativo']; ?></textarea>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="contacto_telefono">Teléfono de Contacto</label>
                                    <input type="text" class="form-control" id="contacto_telefono" name="contacto_telefono" value="<?php echo $cliente['contacto_telefono']; ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label for="contacto_email">Correo Electrónico de Contacto</label>
                                    <input type="email" class="form-control" id="contacto_email" name="contacto_email" value="<?php echo $cliente['contacto_email']; ?>" >
                                </div>

                                <!-- Puedes agregar más campos según la estructura de tu base de datos -->

                                <div class="d-flex justify-content-between">
                                    <a href="clientes.php" class="btn btn-secondary">Volver</a>
                                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>


    <?php include '../assets/includes/navegacion.php'; ?>
<footer class="container">
    <p style="text-align:center;">© Desarrollado por AyP</p>
</footer>

</body>
</html>
