<?php

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}
// ... (código previo, incluyendo inicio de sesión)
include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

// Obtén el nombre de usuario desde la sesión
$nombreUsuario = $_SESSION["nombre_usuario"];

// Obtén la fecha y hora actual
$fechaHoraActual = date("d-m-Y");


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Inicio</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/locale-all.js"></script>


    <style>
        
    </style>

</head>
<body>

    <?php include '../assets/includes/navegacion.php'; ?>

    <!-- COLOCAR SOLO PARA CUANDO NO SE VA A TOMAR COMO AGENDA DE CITAS -->
    <header class="container">
        <a href="registrar_agenda.php">
            <button type="button" class="btn btn-primary" href="registrar_agenda.php"> 
                Agregar Recordatorio
            </button>
        </a>
    </header>
    
    <main class="container-calendar">
        
        <section class="py">
            <div id="calendar"></div>


        <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.js"></script>
        <script src="../assets/js/app.js"></script>
        </section>
    </main>

    <footer class="container">
        <br><br><br><br><br>
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <script src="../assets/js/jquery-3.6.0.min.js"></script>
</body>
</html>
