<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener la lista de consultas médicas
function obtenerConsultasMedicas()
{
    $sql = "SELECT h.id_historial, c.nombre, c.apellido, h.motivo_consulta, h.texto_historial, h.fecha, u.id_usuario, u.nombre AS nombre_medico, u.apellido AS apellido_medico
            FROM historial_medico h
            JOIN clientes c ON h.id_cliente = c.id_cliente
            LEFT JOIN usuarios u ON h.id_medico = u.id_usuario";
    return ejecutarConsulta($sql);
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Consultas Médicas</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Consultas Médicas</h2>
                        </div>
                        <div class="card-body table-responsive">
                            <?php
                            // Obtener la lista de consultas médicas
                            $result = obtenerConsultasMedicas();

                            // Verificar si hay resultados
                            if ($result->num_rows > 0) {
                                echo "<table id='tablaConsultasMedicas' class='table'>
                                        <thead>
                                            <tr>
                                                <th hidden>ID Historial</th>
                                                <th>Cliente</th>
                                                <th>Médico</th>
                                                <th>Motivo Consulta</th>
                                                <th>Diagnostico</th>
                                                <th>Fecha</th>
                                                <th>Acciones</th>
                                            </tr>
                                        </thead>
                                        <tbody>";

                                while ($row = $result->fetch_assoc()) {

                                    $fechaFormateada = date("d-m-Y", strtotime($row["fecha"]));
                                    
                                    echo "<tr>
                                            <td hidden>{$row['id_historial']}</td>
                                            <td>{$row['nombre']} {$row['apellido']}</td>
                                            <td>{$row['nombre_medico']} {$row['apellido_medico']}</td>
                                            <td>{$row['motivo_consulta']}</td>
                                            <td>{$row['texto_historial']}</td>
                                            <td>{$fechaFormateada}</td>
                                            <td>
                                                <a href='#' class='btn-editar' title='Editar'>
                                                    <i class='fa fa-edit'></i>
                                                </a>
                                                <a href='#' class='btn-borrar' title='Borrar'>
                                                    <i class='fa fa-minus' style='color:red;'></i>
                                                </a>
                                            </td>
                                        </tr>";
                                }

                                echo "</tbody></table>";
                            } else {
                                echo "<p>No hay consultas médicas registradas.</p>";
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    <!-- Agrega el script de DataTables -->
    <script type="text/javascript" charset="utf8" src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/buttons/2.0.0/js/buttons.html5.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.0.0/css/buttons.dataTables.min.css">
    <script>
        $(document).ready(function () {
            // Inicializar el DataTable y personalizar la disposición de los elementos
            $('#tablaConsultasMedicas').DataTable({
                dom: "<'row'<'col-md-6'B><'col-md-6'f>>" +
                    "<'row'<'col-md-12'tr>>" +
                    "<'row'<'col-md-6'i><'col-md-6'p>>",
                language: {
                    url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json' // Traducción al español
                },
                buttons: [
                    {
                        text: 'Agregar Nueva Consulta',
                        attr: {
                            id: 'btnAgregar',
                            class: 'btn btn-primary'
                        },
                        action: function () {
                            window.location.href = 'registrar_consulta.php'
                        }
                    }
                ],
                columnDefs: [
                    {
                        targets: -1,
                        width: '100px', // Ajusta el ancho de la columna de acciones
                        className: 'dt-head-center dt-body-center'
                    }
                ],
                responsive: true
            });

            // Agregar evento para editar historial
            $('#tablaConsultasMedicas').on('click', '.btn-editar', function () {
                // Obtiene la fila que contiene los datos del historial
                $tr = $(this).closest('tr');

                // Obtiene el ID del cliente
                var idHistorial = $tr.find("td:eq(0)").text();

                // Redirecciona a la página de edición de historial
                window.location.href = 'editar_consulta.php?id=' + idHistorial;
            });
            
            // Agregar evento para eliminar consulta
            $('#tablaConsultasMedicas').on('click', '.btn-borrar', function () {
                // Obtiene la fila que contiene los datos de la consulta
                $tr = $(this).closest('tr');

                // Obtiene el ID del cliente
                var idConsultaMedica = $tr.find("td:eq(0)").text();
                

                // Pregunta al usuario si desea eliminar el cliente
                if (confirm("¿Estás seguro de eliminar el registro nro: " + idConsultaMedica +" ?")) {
                    // Elimina el registro
                    $.ajax({
                        url: '../assets/includes/eliminar_consulta.php',
                        type: 'POST',
                        data: { idConsultaMedica: idConsultaMedica },
                        success: function (response) {
                            // Verifica si se eliminó el registro
                            if (JSON.parse(response).success) {
                                // Elimina la fila de la tabla
                                $tr.remove();
                            } else {
                                // Muestra un mensaje de error
                                alert(JSON.parse(response).message);
                            }
                        }
                    });
                }
            });

        });
    </script>
</body>
</html>
