<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Calendario de Reservas</title>
  <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.css" integrity="sha512-0Q5b4SO+Lls+xVAzlC8Hf9WYpt93rCT0ulzaRMTezrq1W+mug7zvwkS9lrsCoA+P5XlH6ekJvwn4Sv5zRPT+JQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
</head>
<body>

<?php include '../assets/includes/header.php'; ?>

<main>
  <div class="container">
    <h1>Calendario de Reservas</h1>
    <div class="row">
      <div class="col-md-12">
        <div id="calendario"></div>
      </div>
    </div>
  </div>
</main>

<script src="../assets/js/jquery.min.js"></script>
<script src="../assets/js/bootstrap.bundle.min.js"></script>
<script src='https://cdn.jsdelivr.net/npm/fullcalendar@6.1.9/index.global.min.js'></script>
<script src="../assets/js/moment.min.js"></script>
<script src="../assets/js/es.min.js"></script>
<script>
$(function() {
  // Obtenemos la fecha actual
  var fechaActual = new Date();
  var mesActual = fechaActual.getMonth();
  var anioActual = fechaActual.getFullYear();

  // Creamos el calendario
  var calendario = $('#calendario').fullCalendar({
    defaultDate: new Date(anioActual, mesActual, 1),
    locale: 'es',
    header: {
      left: 'prev,next today',
      center: 'title',
      right: 'month,agendaWeek,agendaDay'
    },
    events: 'ajax/obtener_eventos.php' // Ruta para obtener los eventos desde el servidor
  });
});
</script>

</body>
</html>
