<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Registro de Gastos</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/css/select2.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    
</head>
<body>

    <?php include '../assets/includes/navegacion.php'; ?>

    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Registro de Factura de Gastos</h2>
                        </div>
                        <div class="card-body">

                            <!-- Mostrar datos del proveedor -->
                            <div class="container">
                                <div class="row">
                                    
                                    <div class="col-md-6">
                                        <div class="mb-4">
                                            <h3 style="color: #4664B5;">Datos del Proveedor</h3>
                                            
                                            <hr width="100%" style="color: #999999;"/>
                                                <div class="mb-3">
                                                    <label for="buscar-proveedor">Proveedor</label>
                                                        <br>
                                                        <select id="buscar-proveedor" class="btn btn-outline btn-lg" required>
                                                            <option value="" selected disabled>Buscar Proveedor por Nombre o RUC</option>
                                                        </select>
                                                        <!-- Agrega un campo oculto para almacenar el idUsuario -->
                                                        <input type="hidden" id="idProveedor" name="idProveedor">
                                                </div>
                                                <div class="mb-3">
                                                    <label for="nombreProveedor">Nombre de la Empresa</label>
                                                    <input type="text" class="form-control" id="nombreProveedor" name="nombreProveedor" disabled>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="rucProveedor">RUC o C.I: </label>
                                                    <input type="text" class="form-control" id="rucProveedor" name="rucProveedor" disabled>
                                                </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-4">
                                            <!-- Datos del seguro -->
                                            <h3 style="color: #4664B5;">Datos de la factura</h3>
                                            <hr width="100%" style="color: #999999;"/>
                                                <div class="mb-3">
                                                    <label for="fechaFactura">Fecha de Factura</label>
                                                    <input type="date" class="form-control" id="fechaFactura" name="fechaFactura" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="timbradoFactura">Timbrado de la Factura</label>
                                                    <input type="text" class="form-control" id="timbradoFactura" name="timbradoFactura" placeholder="Introduce el Timbrado de la factura" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="numeroFactura">Número de Factura</label>
                                                    <input type="text" class="form-control" id="numeroFactura" name="numeroFactura" placeholder="Introduce el número de factura" required>
                                                </div>
                                        </div>
                                    </div>

                                </div>
                                <hr width="100%" style="color: #999999;"/>
                            </div>

                            <!-- Sección para agregar las líneas de factura -->
                            <div class="mb-12">
                                <h3 style="color: #4664B5;">Líneas de Factura</h3>
                                <hr width="100%" style="color: #999999;"/>

                                <!-- Botón para agregar nueva línea -->
                                <button class="btn btn-success mb-3" id="btnAgregarLinea">
                                    <i class="fas fa-plus"></i> Agregar Línea
                                </button>

                                <!-- Tabla para mostrar las líneas de factura -->
                                <table class="table table-bordered" id="tablaLineasFactura">
                                    <thead>
                                        <tr>
                                            <th>Cuenta Contable</th>
                                            <th>Observación</th>
                                            <th>Importe Total</th>
                                            <th>IVA 10%</th>
                                            <th>IVA 5%</th>
                                            <th>Excentas</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Aquí se agregarán las filas dinámicamente -->
                                    </tbody>
                                </table>
                            </div>

                            <!-- Sección del boton guardar factura -->
                            <div class="mb-12">
                                <div class="btn-group">
                                    <button class="btn btn-primary" id="btnGuardarFactura">
                                        <i class="fas fa-save"></i> Guardar Factura
                                    </button>
                                    <button class="btn btn-primary" id="btnNuevaFactura" style="display: none;">
                                        <i class="fas fa-plus"></i> Nueva Factura
                                    </button>
                                </div>
                            </div>



                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>


    <!-- Scripts al final para mejorar la carga de la página -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-mQ93GR66B00ZXjt0YO5KlohRA5SY2Xof8+cu6Qr5I5Ih0k5r4aFslw8Z5Gz0D93Q" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.0/dist/js/select2.min.js"></script>
    <script src="../assets/js/c hosen.jquery.min.js"></script>
    
    <script>
        $(document).ready(function () {
            // Configura el evento de entrada en el campo de búsqueda de proveedores
            $('#buscar-proveedor').select2({
                    ajax: {
                        type: 'POST',
                        url: 'buscar_proveedor.php',
                        delay: 250,
                        data: function (params) {
                            return {
                                filtroProveedor: params.term,
                            };
                        },
                        processResults: function (data) {
                            return {
                                results: $.map(data, function (item) {
                                    return {
                                        text: item.nombre_empresa + ' - RUC: ' + item.ruc,
                                        id: item.id_proveedor,
                                        
                                    };
                                }),
                            };
                        },
                        cache: true,
                    },
                    placeholder: 'Buscar Proveedor por Nombre o RUC',
                    minimumInputLength: 2,
                });

                // Agrega un evento change para capturar la selección
                $('#buscar-proveedor').on('change', function (e) {
                    // Obtén el objeto de datos seleccionado
                    var selectedData = $('#buscar-proveedor').select2('data')[0];

                    // Verifica si hay un objeto de datos seleccionado
                    if (selectedData) {
                        // Asigna los valores a los campos correspondientes
                        $('#idProveedor').val(selectedData.id);
                        $('#nombreProveedor').val(selectedData.text.split('-')[0].trim());
                        $('#rucProveedor').val(selectedData.text.split('-')[1].trim());
                    }
                });

                // en el campo de numero de factura se debe de completar de la siguiente manera xxx-xxx-xxxxxxx
                $('#numeroFactura').on('keyup', function (e) {
                    var numeroFactura = $('#numeroFactura').val();
                    var numeroFacturaFormateado = numeroFactura.replace(/(\d{3})(\d{3})(\d{7})/, "$1-$2-$3");
                    $('#numeroFactura').val(numeroFacturaFormateado);
                });
                // Contador para identificar las nuevas líneas de factura
                var contadorLineas = 1;

                // Evento al hacer clic en el botón Agregar Línea
                $('#btnAgregarLinea').on('click', function () {
                    // Agrega una nueva fila a la tabla
                    agregarFila();

                    // Incrementa el contador
                    contadorLineas++;
                });

                // Configura el evento click para el botón de eliminar línea fuera de la función agregarFila
                $(document).on('click', '.btnEliminarLinea', function () {
                    var idFila = $(this).data('id');
                    $('#fila' + idFila).remove();
                });

                
                // funcion para agregar una nueva fila a la tabla
                function agregarFila() {
                    // Crea la nueva fila
                    var fila = '<tr id="fila' + contadorLineas + '">' +
                    '<td>' +
                    '<select class="form-select" id="cuentaContable' + contadorLineas + '" name="cuentaContable' + contadorLineas + '" required>' +
                    '<option value="" selected disabled>Seleccione la cuenta contable...</option>' +
                    '</select>' +
                    '<input type="hidden" id="idCuentaContable' + contadorLineas + '" name="idCuentaContable' + contadorLineas + '">' +
                    '</td>' +
                    '<td>' +
                    '<input type="text" class="form-control" id="observacion' + contadorLineas + '" name="observacion' + contadorLineas + '" placeholder="Introduce una observación" required>' +
                    '</td>' +
                    '<td>' +
                    '<input type="number" class="form-control" id="importeTotal' + contadorLineas + '" name="importeTotal' + contadorLineas + '" placeholder="Total" required>' +
                    '</td>' +
                    '<td>' +
                    '<input type="checkbox" class="form-check-input" id="iva10' + contadorLineas + '" name="iva10' + contadorLineas + '" value="1" required>' +
                    '</td>' +
                    '<td>' +
                    '<input type="checkbox" class="form-check-input" id="iva5' + contadorLineas + '" name="iva5' + contadorLineas + '" value="1" required>' +
                    '</td>' +
                    '<td>' +
                    '<input type="checkbox" class="form-check-input" id="excenta' + contadorLineas + '" name="excenta' + contadorLineas + '" value="1" required>' +
                    '</td>' +
                    '<td>' +
                    '<button class="btn btn-danger btnEliminarLinea" data-id="' + contadorLineas + '"><i class="fas fa-trash"></i></button>' +
                    '</td>' +
                    '</tr>';


                    // Agrega la fila a la tabla
                    $('#tablaLineasFactura tbody').
                    append(fila);

                    // Inicializa select2 en la nueva fila
                    inicializarSelect2EnFila(contadorLineas);
                }

                // Función para inicializar select2 en una fila específica
                function inicializarSelect2EnFila(idFila) {
                    $('#cuentaContable' + idFila).select2({
                        ajax: {
                            type: 'POST',
                            url: 'buscar_cuenta_contable.php',
                            delay: 250,
                            data: function (params) {
                                return {
                                    filtroCuentaContable: params.term,
                                };
                            },
                            processResults: function (data) {
                                return {
                                    results: $.map(data, function (item) {
                                        return {
                                            text: item.nombre_cuenta + ' - Código: ' + item.codigo_cuenta_contable,
                                            id: item.id_cuenta,
                                        };
                                    }),
                                };
                            },
                            cache: true,
                        },
                        placeholder: 'Buscar Cuenta Contable por Nombre o Código',
                        minimumInputLength: 2,
                    });
                }

                // agregar un evento para capturar la seleccion de cuenta contable
                $(document).on('change', '[id^=cuentaContable]', function (e) {
                    // Obtén el objeto de datos seleccionado
                    var selectedData = $(this).select2('data')[0];

                    // Verifica si hay un objeto de datos seleccionado
                    if (selectedData) {
                        // Asigna los valores a los campos correspondientes
                        var idFila = $(this).attr('id').replace('cuentaContable', '');
                        $('#idCuentaContable' + idFila).val(selectedData.id);
                    }
                });

                // Configura el evento click para el botón de guardar factura
                $('#btnGuardarFactura').on('click', function () {
                    // Verificar si la factura ya existe con el mismo proveedor y número de factura
                    var idProveedor = $('#idProveedor').val();
                    var numeroFactura = $('#numeroFactura').val();

                    verificarExistenciaFactura(idProveedor, numeroFactura)
                        .then(function (existeFactura) {
                            if (!existeFactura) {
                                guardarFactura();
                            } else {
                                alert('La factura ya existe.');
                            }
                        })
                        .catch(function (error) {
                            console.error('Error en la verificación de factura:', error);
                        });
                });

                // Configura el evento click para el botón de nueva factura
                $('#btnNuevaFactura').on('click', function () {
                    nuevaFactura();
                });

                // Otras funciones...

                function verificarExistenciaFactura(idProveedor, numeroFactura) {
                    return new Promise(function (resolve, reject) {
                        $.ajax({
                            type: 'POST',
                            url: 'verificar_factura.php',
                            data: {
                                idProveedor: idProveedor,
                                numeroFactura: numeroFactura
                            },
                            success: function (data) {
                                if (data === 'La factura no existe.') {
                                    resolve(false);
                                } else {
                                    resolve(true);
                                }
                            },
                            error: function () {
                                reject('Error en la verificación de factura.');
                            }
                        });
                    });
                }

                function guardarFactura() {
                    // Realiza las validaciones necesarias
                    if ($('#idProveedor').val() === '' || $('#fechaFactura').val() === '' || $('#timbradoFactura').val() === '' || $('#numeroFactura').val() === '' || $('#tablaLineasFactura tbody tr').length === 0) {
                        alert('Por favor, complete todos los campos obligatorios y agregue al menos una línea de factura.');
                        return;
                    }

                    // Calcular los importes totales, IVA 10%, IVA 5%, y Excenta
                    var importeTotal = 0;
                    var iva10 = 0;
                    var iva5 = 0;
                    var excenta = 0;

                    $('#tablaLineasFactura tbody tr').each(function () {
                        var importeTotalLinea = parseFloat($(this).find('[name^=importeTotal]').val()) || 0;
                        importeTotal += importeTotalLinea;

                        if ($(this).find('[name^=iva10]').is(':checked')) {
                            iva10 += (importeTotalLinea / 11);
                        }

                        if ($(this).find('[name^=iva5]').is(':checked')) {
                            iva5 += (importeTotalLinea / 21);
                        }

                        if ($(this).find('[name^=excenta]').is(':checked')) {
                            excenta += 0;
                        }
                    });

                    // Realizar la llamada AJAX para guardar en la tabla facturas_compras
                    $.ajax({
                        type: 'POST',
                        url: 'guardar_factura.php',
                        data: {
                            idProveedor: $('#idProveedor').val(),
                            fechaFactura: $('#fechaFactura').val(),
                            timbradoFactura: $('#timbradoFactura').val(),
                            numeroFactura: $('#numeroFactura').val(),
                            importeTotal: importeTotal,
                            iva10: iva10,
                            iva5: iva5,
                            excenta: excenta
                        },
                        success: function (data) {
                            // El servidor debe devolver el ID de la factura insertada
                            var idFactura = parseInt(data);

                            // Realizar la llamada AJAX para guardar en la tabla detalle_factura
                            guardarDetalleFactura(idFactura);
                        }
                    });

                    // Otras acciones después de guardar la factura
                    alert('Factura guardada correctamente.');
                    // Puedes redirigir a otra página, limpiar el formulario, etc.
                    deshabilitarCampos();
                    mostrarBotonNuevaFactura();
                }

                function guardarDetalleFactura(idFactura) {
                    // Realizar la llamada AJAX para guardar en la tabla detalle_factura
                    $('#tablaLineasFactura tbody tr').each(function () {
                        $.ajax({
                            type: 'POST',
                            url: 'guardar_detalle_factura.php',
                            data: {
                                idFactura: idFactura,
                                observacion: $(this).find('[name^=observacion]').val(),
                                importeTotal: parseFloat($(this).find('[name^=importeTotal]').val()) || 0,
                                iva10: $(this).find('[name^=iva10]').is(':checked') ? 1 : 0,
                                iva5: $(this).find('[name^=iva5]').is(':checked') ? 1 : 0,
                                excenta: $(this).find('[name^=excenta]').is(':checked') ? 1 : 0,
                                idCuentaContable: $(this).find('[name^=idCuentaContable]').val()
                            },
                            success: function (data) {
                                // Manejar la respuesta del servidor si es necesario
                            }
                        });
                    });
                }

                function deshabilitarCampos() {
                    // Deshabilitar campos de proveedores, facturas, timbrados, fecha y líneas de factura
                    $('#buscar-proveedor').prop('disabled', true);
                    $('#fechaFactura').prop('disabled', true);
                    $('#timbradoFactura').prop('disabled', true);
                    $('#numeroFactura').prop('disabled', true);
                    $('#tablaLineasFactura :input').prop('disabled', true);
                    // Ocultar el botón para agregar una nueva línea
                    $('#btnAgregarLinea').hide();
                    // Ocultar el botón para guardar la factura
                    $('#btnGuardarFactura').hide();
                }

                function mostrarBotonNuevaFactura() {
                    // Mostrar el botón para crear una nueva factura
                    $('#btnNuevaFactura').show();
                }

                function nuevaFactura() {
                    //recargar la pagina asi se restauran los campos
                    location.reload();
                }


                    
            });
    </script>    

</body>
</html>
