<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión

if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php'; // Asegúrate de proporcionar la ruta correcta

$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// funcion para insertar registros y mostrar errores de consulta si hubieran
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Obtén los datos del formulario
    $estudio_medico = $_POST["estudio_medico"];
    $precio = $_POST["precio"];
    $categoria_estudio_medico = $_POST["categoria_estudio_medico"];
    // Puedes agregar más campos según la estructura de tu base de datos

    // Inserta el nuevo estudio medico en la base de datos

    $stmt = $conn->prepare("INSERT INTO estudios_medicos (nombre_estudio, precio, id_categoria_estudios) VALUES (?, ?, ?)");

    if ($stmt === false) {
        die('Error de preparación de la consulta: ' . $conn->error);
    }

    $stmt->bind_param("sii", $estudio_medico, $precio, $categoria_estudio_medico);
    $exitoInsercion = $stmt->execute();


    if ($exitoInsercion) {
        // Redirige a la página de estudio medico con un mensaje de éxito en alert
        echo "<script>alert('Estudio médico agregado exitosamente'); window.location.href='estudios_medicos.php';</script>";
        exit();
    } else {
        // Redirige a la página de estudio medico con un mensaje de error
        header("Location: estudios_medicos.php");
        exit();
    }
    $stmt->close();
}


// obtener categoria_estudio_medico
$categoria_estudio_medico = ejecutarConsulta("SELECT * FROM categoria_estudios");


?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Registrar Estudio Médico</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">
    
</head>
<body>
    <?php include '../assets/includes/navegacion.php'; ?>
    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Registrar Estudio Médico</h2>
                        </div>
                        <div class="card-body">
                            <form action="" method="post">
                                <div class="mb-3">
                                    <label for="categoria_estudio_medico">Categoría Estudio Médico</label>
                                    <select class="form-select" id="categoria_estudio_medico" name="categoria_estudio_medico" required>
                                        <option value="">Selecciona una categoría</option>
                                        <?php
                                        while ($row = mysqli_fetch_array($categoria_estudio_medico)) {
                                            echo "<option value='" . $row['id_categoria_estudios'] . "'>" . $row['nombre_categoria_estudio'] . "</option>";
                                        }
                                        ?>
                                    </select>

                                </div>
                                <div class="mb-3">
                                    <label for="estudio_medico">Estudio Médico</label>
                                    <input type="text" class="form-control" id="estudio_medico" name="estudio_medico" placeholder="Escribe la estudio médico" required>
                                </div>
                                <div class="mb-3">
                                    <label for="precio">Precio</label>
                                    <input type="number" class="form-control" id="precio" name="precio" placeholder="Escribe el precio">
                                </div>
                                <div class="d-flex justify-content-between">
                                    <a href="estudios_medicos.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Registrar Estudio</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

    </body>
</html>

