<?php

// Inicia la sesión
session_start();

// Verifica si el usuario ha iniciado sesión
if (!isset($_SESSION["nombre_usuario"])) {
    // Si no ha iniciado sesión, redirige a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit();
}

include '../assets/includes/conexion.php';
$conexionDB = new ConexionDB();
$conn = $conexionDB->conectar();

// Función para ejecutar consultas
function ejecutarConsulta($sql)
{
    global $conn;
    return $conn->query($sql);
}

// Obtener Categoria de Clientes
function obtenerCategoriaClientes()
{
    $sql = "SELECT * FROM categoria_cliente";
    return ejecutarConsulta($sql);
}

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dentox - Agregar Cliente</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="../assets/css/styles.css">
    <link rel="stylesheet" type="text/css" href="../assets/css/menu.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css">

</head>

<body>

    <main class="container">
        <section class="py-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <img src="../assets/images/Dentox.png" width="150" class="logo">
                            <h2 class="ms-4">Agregar Nuevo Paciente</h2>
                        </div>
                        <div class="card-body">
                            <form action="../assets/includes/procesar_agregar_cliente.php" method="post">
                                <div class="mb-3">
                                    <label for="nombre">Nombre</label>
                                    <input type="text" class="form-control" id="nombre" name="nombre" placeholder="Introduce el nombre" required>
                                </div>
                                <div class="mb-3">
                                    <label for="apellido">Apellido</label>
                                    <input type="text" class="form-control" id="apellido" name="apellido" placeholder="Introduce el apellido" required>
                                </div>
                                <div class="mb-3">
                                    <label for="cedula">Cédula</label>
                                    <input type="text" class="form-control" id="cedula" name="cedula" placeholder="Introduce la cédula" required>
                                </div>
                                <div class="mb-3">
                                    <label for="fecha_nacimiento">Fecha de Nacimiento</label>
                                    <input type="date" class="form-control" id="fecha_nacimiento" name="fecha_nacimiento" placeholder="Introduce la fecha de nacimiento">
                                </div>
                                <div class="mb-3">
                                <label for="categoria">Categoria:</label>
                                <select class="form-select" id="categoria" name="categoria" required>
                                    <option value="" selected disabled>Seleccione la Categoria...</option>
                                    <?php
                                    // Obtener la lista de categorias desde la base de datos
                                    $categoria = obtenerCategoriaClientes();

                                    // Verificar si hay categorias
                                    if ($categoria->num_rows > 0) {
                                    while ($cat_cliente = $categoria->fetch_assoc()) {
                                        echo "<option value='{$cat_cliente['id_categoria']}'>{$cat_cliente['nombre_categoria']}</option>";
                                    }
                                    }
                                    ?>
                                </select>
                                </div>
                                <div class="mb-3" hidden>
                                    <label for="resumen">Resumen Administrativo</label>
                                    <textarea class="form-control" id="resumen" name="resumen" placeholder="Introduce el resumen"></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="contacto_telefono">Teléfono de Contacto</label>
                                    <input type="text" class="form-control" id="contacto_telefono" name="contacto_telefono" placeholder="Introduce el teléfono de contacto" required>
                                </div>
                                <div class="mb-3">
                                    <label for="contacto_email">Email de Contacto</label>
                                    <input type="email" class="form-control" id="contacto_email" name="contacto_email" placeholder="Introduce el email de contacto">
                                </div>
                                <!-- Puedes agregar más campos según la estructura de tu base de datos -->

                                <div class="d-flex justify-content-between">
                                    <a href="clientes.php"><button type="button" class="btn btn-secondary">Volver</button></a>
                                    <button type="submit" class="btn btn-primary">Agregar Cliente</button>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>
    <?php include '../assets/includes/navegacion.php'; ?>
    <footer class="container">
        <p style="text-align:center;">© Desarrollado por AyP</p>
    </footer>

</body>

</html>
